/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.ui.topo.NodeSelection;

public class NodeSelectionTest {
    private final ObjectMapper mapper = new ObjectMapper();
    private static final String IDS = "ids";
    private static final String HOVER = "hover";
    private static final DeviceId DEVICE_1_ID = DeviceId.deviceId((String)"Device-1");
    private static final DeviceId DEVICE_2_ID = DeviceId.deviceId((String)"Device-2");
    private static final HostId HOST_A_ID = HostId.hostId((String)"aa:aa:aa:aa:aa:aa/1");
    private static final HostId HOST_B_ID = HostId.hostId((String)"bb:bb:bb:bb:bb:bb/2");
    private static final Device DEVICE_1 = new FakeDevice(DEVICE_1_ID);
    private static final Device DEVICE_2 = new FakeDevice(DEVICE_2_ID);
    private static final Host HOST_A = new FakeHost(HOST_A_ID);
    private static final Host HOST_B = new FakeHost(HOST_B_ID);
    private DeviceService deviceService = new FakeDevices();
    private HostService hostService = new FakeHosts();
    private NodeSelection ns;

    private ObjectNode objectNode() {
        return this.mapper.createObjectNode();
    }

    private ArrayNode arrayNode() {
        return this.mapper.createArrayNode();
    }

    private NodeSelection createNodeSelection(ObjectNode payload) {
        return new NodeSelection(payload, this.deviceService, this.hostService);
    }

    private ObjectNode emptySelection() {
        ObjectNode payload = this.objectNode();
        ArrayNode ids = this.arrayNode();
        payload.set(IDS, (JsonNode)ids);
        return payload;
    }

    private ObjectNode oneDeviceSelected() {
        ObjectNode payload = this.objectNode();
        ArrayNode ids = this.arrayNode();
        payload.set(IDS, (JsonNode)ids);
        ids.add(DEVICE_1_ID.toString());
        return payload;
    }

    private ObjectNode oneHostSelected() {
        ObjectNode payload = this.objectNode();
        ArrayNode ids = this.arrayNode();
        payload.set(IDS, (JsonNode)ids);
        ids.add(HOST_A_ID.toString());
        return payload;
    }

    private ObjectNode twoHostsOneDeviceSelected() {
        ObjectNode payload = this.objectNode();
        ArrayNode ids = this.arrayNode();
        payload.set(IDS, (JsonNode)ids);
        ids.add(HOST_A_ID.toString());
        ids.add(DEVICE_1_ID.toString());
        ids.add(HOST_B_ID.toString());
        return payload;
    }

    private ObjectNode oneHostAndHoveringDeviceSelected() {
        ObjectNode payload = this.objectNode();
        ArrayNode ids = this.arrayNode();
        payload.set(IDS, (JsonNode)ids);
        ids.add(HOST_A_ID.toString());
        payload.put(HOVER, DEVICE_2_ID.toString());
        return payload;
    }

    private ObjectNode twoDevicesOneHostAndHoveringHostSelected() {
        ObjectNode payload = this.objectNode();
        ArrayNode ids = this.arrayNode();
        payload.set(IDS, (JsonNode)ids);
        ids.add(HOST_A_ID.toString());
        ids.add(DEVICE_1_ID.toString());
        ids.add(DEVICE_2_ID.toString());
        payload.put(HOVER, HOST_B_ID.toString());
        return payload;
    }

    @Test
    public void basic() {
        this.ns = this.createNodeSelection(this.emptySelection());
        Assert.assertEquals((String)"unexpected devices", (long)0L, (long)this.ns.devices().size());
        Assert.assertEquals((String)"unexpected devices w/hover", (long)0L, (long)this.ns.devicesWithHover().size());
        Assert.assertEquals((String)"unexpected hosts", (long)0L, (long)this.ns.hosts().size());
        Assert.assertEquals((String)"unexpected hosts w/hover", (long)0L, (long)this.ns.hostsWithHover().size());
        Assert.assertTrue((String)"unexpected selection", (boolean)this.ns.none());
        Assert.assertNull((String)"hover?", (Object)this.ns.hovered());
    }

    @Test
    public void oneDevice() {
        this.ns = this.createNodeSelection(this.oneDeviceSelected());
        Assert.assertEquals((String)"missing device", (long)1L, (long)this.ns.devices().size());
        Assert.assertTrue((String)"missing device 1", (boolean)this.ns.devices().contains(DEVICE_1));
        Assert.assertEquals((String)"missing device w/hover", (long)1L, (long)this.ns.devicesWithHover().size());
        Assert.assertTrue((String)"missing device 1 w/hover", (boolean)this.ns.devicesWithHover().contains(DEVICE_1));
        Assert.assertEquals((String)"unexpected hosts", (long)0L, (long)this.ns.hosts().size());
        Assert.assertEquals((String)"unexpected hosts w/hover", (long)0L, (long)this.ns.hostsWithHover().size());
        Assert.assertFalse((String)"unexpected selection", (boolean)this.ns.none());
        Assert.assertNull((String)"hover?", (Object)this.ns.hovered());
    }

    @Test
    public void oneHost() {
        this.ns = this.createNodeSelection(this.oneHostSelected());
        Assert.assertEquals((String)"unexpected devices", (long)0L, (long)this.ns.devices().size());
        Assert.assertEquals((String)"unexpected devices w/hover", (long)0L, (long)this.ns.devicesWithHover().size());
        Assert.assertEquals((String)"missing host", (long)1L, (long)this.ns.hosts().size());
        Assert.assertTrue((String)"missing host A", (boolean)this.ns.hosts().contains(HOST_A));
        Assert.assertEquals((String)"missing host w/hover", (long)1L, (long)this.ns.hostsWithHover().size());
        Assert.assertTrue((String)"missing host A w/hover", (boolean)this.ns.hostsWithHover().contains(HOST_A));
        Assert.assertFalse((String)"unexpected selection", (boolean)this.ns.none());
        Assert.assertNull((String)"hover?", (Object)this.ns.hovered());
    }

    @Test
    public void twoHostsOneDevice() {
        this.ns = this.createNodeSelection(this.twoHostsOneDeviceSelected());
        Assert.assertEquals((String)"missing device", (long)1L, (long)this.ns.devices().size());
        Assert.assertTrue((String)"missing device 1", (boolean)this.ns.devices().contains(DEVICE_1));
        Assert.assertEquals((String)"missing device w/hover", (long)1L, (long)this.ns.devicesWithHover().size());
        Assert.assertTrue((String)"missing device 1 w/hover", (boolean)this.ns.devicesWithHover().contains(DEVICE_1));
        Assert.assertEquals((String)"unexpected hosts", (long)2L, (long)this.ns.hosts().size());
        Assert.assertTrue((String)"missing host A", (boolean)this.ns.hosts().contains(HOST_A));
        Assert.assertTrue((String)"missing host B", (boolean)this.ns.hosts().contains(HOST_B));
        Assert.assertEquals((String)"unexpected hosts w/hover", (long)2L, (long)this.ns.hostsWithHover().size());
        Assert.assertTrue((String)"missing host A w/hover", (boolean)this.ns.hostsWithHover().contains(HOST_A));
        Assert.assertTrue((String)"missing host B w/hover", (boolean)this.ns.hostsWithHover().contains(HOST_B));
        Assert.assertFalse((String)"unexpected selection", (boolean)this.ns.none());
        Assert.assertNull((String)"hover?", (Object)this.ns.hovered());
    }

    @Test
    public void oneHostAndHoveringDevice() {
        this.ns = this.createNodeSelection(this.oneHostAndHoveringDeviceSelected());
        Assert.assertEquals((String)"unexpected devices", (long)0L, (long)this.ns.devices().size());
        Assert.assertEquals((String)"unexpected devices w/hover", (long)1L, (long)this.ns.devicesWithHover().size());
        Assert.assertTrue((String)"missing device 2 w/hover", (boolean)this.ns.devicesWithHover().contains(DEVICE_2));
        Assert.assertEquals((String)"missing host", (long)1L, (long)this.ns.hosts().size());
        Assert.assertTrue((String)"missing host A", (boolean)this.ns.hosts().contains(HOST_A));
        Assert.assertEquals((String)"missing host w/hover", (long)1L, (long)this.ns.hostsWithHover().size());
        Assert.assertTrue((String)"missing host A w/hover", (boolean)this.ns.hostsWithHover().contains(HOST_A));
        Assert.assertFalse((String)"unexpected selection", (boolean)this.ns.none());
        Assert.assertEquals((String)"missing hover device 2", (Object)DEVICE_2, (Object)this.ns.hovered());
    }

    @Test
    public void twoDevicesOneHostAndHoveringHost() {
        this.ns = this.createNodeSelection(this.twoDevicesOneHostAndHoveringHostSelected());
        Assert.assertEquals((String)"missing devices", (long)2L, (long)this.ns.devices().size());
        Assert.assertTrue((String)"missing device 1", (boolean)this.ns.devices().contains(DEVICE_1));
        Assert.assertTrue((String)"missing device 2", (boolean)this.ns.devices().contains(DEVICE_2));
        Assert.assertEquals((String)"missing devices w/hover", (long)2L, (long)this.ns.devicesWithHover().size());
        Assert.assertTrue((String)"missing device 1 w/hover", (boolean)this.ns.devicesWithHover().contains(DEVICE_1));
        Assert.assertTrue((String)"missing device 2 w/hover", (boolean)this.ns.devicesWithHover().contains(DEVICE_2));
        Assert.assertEquals((String)"missing host", (long)1L, (long)this.ns.hosts().size());
        Assert.assertTrue((String)"missing host A", (boolean)this.ns.hosts().contains(HOST_A));
        Assert.assertEquals((String)"missing host w/hover", (long)2L, (long)this.ns.hostsWithHover().size());
        Assert.assertTrue((String)"missing host A w/hover", (boolean)this.ns.hostsWithHover().contains(HOST_A));
        Assert.assertTrue((String)"missing host B w/hover", (boolean)this.ns.hostsWithHover().contains(HOST_B));
        Assert.assertFalse((String)"unexpected selection", (boolean)this.ns.none());
        Assert.assertEquals((String)"missing hover host B", (Object)HOST_B, (Object)this.ns.hovered());
    }

    private static class FakeHosts
    extends HostServiceAdapter {
        private FakeHosts() {
        }

        @Override
        public Host getHost(HostId hostId) {
            if (HOST_A_ID.equals((Object)hostId)) {
                return HOST_A;
            }
            if (HOST_B_ID.equals((Object)hostId)) {
                return HOST_B;
            }
            return null;
        }
    }

    private static class FakeDevices
    extends DeviceServiceAdapter {
        private FakeDevices() {
        }

        @Override
        public Device getDevice(DeviceId deviceId) {
            if (DEVICE_1_ID.equals((Object)deviceId)) {
                return DEVICE_1;
            }
            if (DEVICE_2_ID.equals((Object)deviceId)) {
                return DEVICE_2;
            }
            return null;
        }
    }

    private static class FakeHost
    extends DefaultHost {
        FakeHost(HostId id) {
            super(null, id, null, null, null, (Set)ImmutableSet.of(), new Annotations[0]);
        }
    }

    private static class FakeDevice
    extends DefaultDevice {
        FakeDevice(DeviceId id) {
            super(null, id, null, null, null, null, null, null, new Annotations[0]);
        }
    }
}

