/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.HostId;
import org.onosproject.net.config.basics.BasicElementConfig;

public final class BasicHostConfig
extends BasicElementConfig<HostId> {
    private static final String IPS = "ips";
    private static final String LOCATION = "location";

    @Override
    public boolean isValid() {
        this.location();
        this.ipAddresses();
        return this.hasOnlyFields("allowed", "name", "latitude", "longitude", "rackAddress", "owner", IPS, LOCATION);
    }

    public ConnectPoint location() {
        String location = this.get(LOCATION, null);
        return location != null ? ConnectPoint.deviceConnectPoint(location) : null;
    }

    public BasicHostConfig setLocation(String location) {
        return (BasicHostConfig)this.setOrClear(LOCATION, location);
    }

    public Set<IpAddress> ipAddresses() {
        HashSet<IpAddress> ipAddresses = new HashSet<IpAddress>();
        if (this.object.has(IPS)) {
            ArrayNode ipNodes = (ArrayNode)this.object.path(IPS);
            ipNodes.forEach(n -> ipAddresses.add(IpAddress.valueOf((String)n.asText())));
            return ipAddresses;
        }
        return null;
    }

    public BasicHostConfig setIps(Set<IpAddress> ipAddresses) {
        return (BasicHostConfig)this.setOrClear(IPS, ipAddresses);
    }
}

