/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L1ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flow.instructions.L4ModificationInstruction;
import org.onosproject.net.meter.MeterId;

public final class Instructions {
    private static final String SEPARATOR = ":";

    private Instructions() {
    }

    public static OutputInstruction createOutput(PortNumber number) {
        Preconditions.checkNotNull((Object)number, (Object)"PortNumber cannot be null");
        return new OutputInstruction(number);
    }

    public static NoActionInstruction createNoAction() {
        return new NoActionInstruction();
    }

    public static GroupInstruction createGroup(GroupId groupId) {
        Preconditions.checkNotNull((Object)groupId, (Object)"GroupId cannot be null");
        return new GroupInstruction(groupId);
    }

    public static SetQueueInstruction setQueue(long queueId, PortNumber port) {
        Preconditions.checkNotNull((Object)queueId, (Object)"queue ID cannot be null");
        return new SetQueueInstruction(queueId, port);
    }

    public static MeterInstruction meterTraffic(MeterId meterId) {
        Preconditions.checkNotNull((Object)((Object)meterId), (Object)"meter id cannot be null");
        return new MeterInstruction(meterId);
    }

    public static L0ModificationInstruction modL0Lambda(Lambda lambda) {
        Preconditions.checkNotNull((Object)lambda, (Object)"L0 OCh signal cannot be null");
        if (lambda instanceof OchSignal) {
            return new L0ModificationInstruction.ModOchSignalInstruction((OchSignal)lambda);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type: %s", lambda));
    }

    public static L1ModificationInstruction modL1OduSignalId(OduSignalId oduSignalId) {
        Preconditions.checkNotNull((Object)oduSignalId, (Object)"L1 ODU signal ID cannot be null");
        return new L1ModificationInstruction.ModOduSignalIdInstruction(oduSignalId);
    }

    public static L2ModificationInstruction modL2Src(MacAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Src l2 address cannot be null");
        return new L2ModificationInstruction.ModEtherInstruction(L2ModificationInstruction.L2SubType.ETH_SRC, addr);
    }

    public static L2ModificationInstruction modL2Dst(MacAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Dst l2 address cannot be null");
        return new L2ModificationInstruction.ModEtherInstruction(L2ModificationInstruction.L2SubType.ETH_DST, addr);
    }

    public static L2ModificationInstruction modVlanId(VlanId vlanId) {
        Preconditions.checkNotNull((Object)vlanId, (Object)"VLAN id cannot be null");
        return new L2ModificationInstruction.ModVlanIdInstruction(vlanId);
    }

    public static L2ModificationInstruction modVlanPcp(Byte vlanPcp) {
        Preconditions.checkNotNull((Object)vlanPcp, (Object)"VLAN Pcp cannot be null");
        return new L2ModificationInstruction.ModVlanPcpInstruction(vlanPcp);
    }

    public static L2ModificationInstruction modMplsLabel(MplsLabel mplsLabel) {
        Preconditions.checkNotNull((Object)mplsLabel, (Object)"MPLS label cannot be null");
        return new L2ModificationInstruction.ModMplsLabelInstruction(mplsLabel);
    }

    public static L2ModificationInstruction modMplsBos(boolean mplsBos) {
        return new L2ModificationInstruction.ModMplsBosInstruction(mplsBos);
    }

    public static L2ModificationInstruction decMplsTtl() {
        return new L2ModificationInstruction.ModMplsTtlInstruction();
    }

    public static L3ModificationInstruction modL3Src(IpAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Src l3 IPv4 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV4_SRC, addr);
    }

    public static L3ModificationInstruction modL3Dst(IpAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Dst l3 IPv4 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV4_DST, addr);
    }

    public static L3ModificationInstruction modL3IPv6Src(IpAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Src l3 IPv6 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV6_SRC, addr);
    }

    public static L3ModificationInstruction modL3IPv6Dst(IpAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Dst l3 IPv6 address cannot be null");
        return new L3ModificationInstruction.ModIPInstruction(L3ModificationInstruction.L3SubType.IPV6_DST, addr);
    }

    public static L3ModificationInstruction modL3IPv6FlowLabel(int flowLabel) {
        return new L3ModificationInstruction.ModIPv6FlowLabelInstruction(flowLabel);
    }

    public static L3ModificationInstruction decNwTtl() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.DEC_TTL);
    }

    public static L3ModificationInstruction copyTtlOut() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.TTL_OUT);
    }

    public static L3ModificationInstruction copyTtlIn() {
        return new L3ModificationInstruction.ModTtlInstruction(L3ModificationInstruction.L3SubType.TTL_IN);
    }

    public static L3ModificationInstruction modArpSpa(IpAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Src l3 ARP IP address cannot be null");
        return new L3ModificationInstruction.ModArpIPInstruction(L3ModificationInstruction.L3SubType.ARP_SPA, addr);
    }

    public static L3ModificationInstruction modArpSha(MacAddress addr) {
        Preconditions.checkNotNull((Object)addr, (Object)"Src l3 ARP address cannot be null");
        return new L3ModificationInstruction.ModArpEthInstruction(L3ModificationInstruction.L3SubType.ARP_SHA, addr);
    }

    public static L3ModificationInstruction modL3ArpOp(short op) {
        Preconditions.checkNotNull((Object)op, (Object)"Arp operation cannot be null");
        return new L3ModificationInstruction.ModArpOpInstruction(L3ModificationInstruction.L3SubType.ARP_OP, op);
    }

    public static Instruction pushMpls() {
        return new L2ModificationInstruction.ModMplsHeaderInstruction(L2ModificationInstruction.L2SubType.MPLS_PUSH, EthType.EtherType.MPLS_UNICAST.ethType());
    }

    public static Instruction popMpls() {
        return new L2ModificationInstruction.ModMplsHeaderInstruction(L2ModificationInstruction.L2SubType.MPLS_POP, EthType.EtherType.MPLS_UNICAST.ethType());
    }

    public static Instruction popMpls(EthType etherType) {
        Preconditions.checkNotNull((Object)etherType, (Object)"Ethernet type cannot be null");
        return new L2ModificationInstruction.ModMplsHeaderInstruction(L2ModificationInstruction.L2SubType.MPLS_POP, etherType);
    }

    public static Instruction popVlan() {
        return new L2ModificationInstruction.ModVlanHeaderInstruction(L2ModificationInstruction.L2SubType.VLAN_POP);
    }

    public static Instruction pushVlan() {
        return new L2ModificationInstruction.ModVlanHeaderInstruction(L2ModificationInstruction.L2SubType.VLAN_PUSH, EthType.EtherType.VLAN.ethType());
    }

    public static Instruction transition(Integer tableId) {
        Preconditions.checkNotNull((Object)tableId, (Object)"Table id cannot be null");
        return new TableTypeTransition(tableId);
    }

    public static Instruction writeMetadata(long metadata, long metadataMask) {
        return new MetadataInstruction(metadata, metadataMask);
    }

    public static L2ModificationInstruction modTunnelId(long tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)"Tunnel id cannot be null");
        return new L2ModificationInstruction.ModTunnelIdInstruction(tunnelId);
    }

    public static L4ModificationInstruction modTcpSrc(TpPort port) {
        Preconditions.checkNotNull((Object)port, (Object)"Src TCP port cannot be null");
        return new L4ModificationInstruction.ModTransportPortInstruction(L4ModificationInstruction.L4SubType.TCP_SRC, port);
    }

    public static L4ModificationInstruction modTcpDst(TpPort port) {
        Preconditions.checkNotNull((Object)port, (Object)"Dst TCP port cannot be null");
        return new L4ModificationInstruction.ModTransportPortInstruction(L4ModificationInstruction.L4SubType.TCP_DST, port);
    }

    public static L4ModificationInstruction modUdpSrc(TpPort port) {
        Preconditions.checkNotNull((Object)port, (Object)"Src UDP port cannot be null");
        return new L4ModificationInstruction.ModTransportPortInstruction(L4ModificationInstruction.L4SubType.UDP_SRC, port);
    }

    public static L4ModificationInstruction modUdpDst(TpPort port) {
        Preconditions.checkNotNull((Object)port, (Object)"Dst UDP port cannot be null");
        return new L4ModificationInstruction.ModTransportPortInstruction(L4ModificationInstruction.L4SubType.UDP_DST, port);
    }

    public static ExtensionInstructionWrapper extension(ExtensionTreatment extension, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)extension, (Object)"Extension instruction cannot be null");
        Preconditions.checkNotNull((Object)deviceId, (Object)"Device ID cannot be null");
        return new ExtensionInstructionWrapper(extension, deviceId);
    }

    public static class ExtensionInstructionWrapper
    implements Instruction {
        private final ExtensionTreatment extensionTreatment;
        private final DeviceId deviceId;

        ExtensionInstructionWrapper(ExtensionTreatment extension, DeviceId deviceId) {
            this.extensionTreatment = extension;
            this.deviceId = deviceId;
        }

        public ExtensionTreatment extensionInstruction() {
            return this.extensionTreatment;
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.EXTENSION;
        }

        public String toString() {
            return this.type().toString() + Instructions.SEPARATOR + this.deviceId + "/" + this.extensionTreatment;
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.extensionTreatment, this.deviceId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExtensionInstructionWrapper) {
                ExtensionInstructionWrapper that = (ExtensionInstructionWrapper)obj;
                return Objects.equals(this.extensionTreatment, that.extensionTreatment) && Objects.equals(this.deviceId, that.deviceId);
            }
            return false;
        }
    }

    public static class MetadataInstruction
    implements Instruction {
        private final long metadata;
        private final long metadataMask;

        MetadataInstruction(long metadata, long metadataMask) {
            this.metadata = metadata;
            this.metadataMask = metadataMask;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.METADATA;
        }

        public long metadata() {
            return this.metadata;
        }

        public long metadataMask() {
            return this.metadataMask;
        }

        public String toString() {
            return this.type().toString() + Instructions.SEPARATOR + Long.toHexString(this.metadata) + "/" + Long.toHexString(this.metadataMask);
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.metadata, this.metadataMask);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MetadataInstruction) {
                MetadataInstruction that = (MetadataInstruction)obj;
                return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.metadataMask, that.metadataMask);
            }
            return false;
        }
    }

    public static class TableTypeTransition
    implements Instruction {
        private final Integer tableId;

        TableTypeTransition(Integer tableId) {
            this.tableId = tableId;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.TABLE;
        }

        public Integer tableId() {
            return this.tableId;
        }

        public String toString() {
            return this.type().toString() + Instructions.SEPARATOR + this.tableId;
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.tableId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TableTypeTransition) {
                TableTypeTransition that = (TableTypeTransition)obj;
                return Objects.equals(this.tableId, that.tableId);
            }
            return false;
        }
    }

    public static final class MeterInstruction
    implements Instruction {
        private final MeterId meterId;

        private MeterInstruction(MeterId meterId) {
            this.meterId = meterId;
        }

        public MeterId meterId() {
            return this.meterId;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.METER;
        }

        public String toString() {
            return this.type().toString() + Instructions.SEPARATOR + this.meterId.id();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type().ordinal(), this.meterId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MeterInstruction) {
                MeterInstruction that = (MeterInstruction)obj;
                return Objects.equals((Object)this.meterId, (Object)that.meterId);
            }
            return false;
        }
    }

    public static final class SetQueueInstruction
    implements Instruction {
        private final long queueId;
        private final PortNumber port;

        private SetQueueInstruction(long queueId) {
            this.queueId = queueId;
            this.port = null;
        }

        private SetQueueInstruction(long queueId, PortNumber port) {
            this.queueId = queueId;
            this.port = port;
        }

        public long queueId() {
            return this.queueId;
        }

        public PortNumber port() {
            return this.port;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.QUEUE;
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((String)this.type().toString());
            toStringHelper.add("queueId", this.queueId);
            if (this.port() != null) {
                toStringHelper.add("port", (Object)this.port);
            }
            return toStringHelper.toString();
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.queueId, this.port);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SetQueueInstruction) {
                SetQueueInstruction that = (SetQueueInstruction)obj;
                return Objects.equals(this.queueId, that.queueId) && Objects.equals(this.port, that.port);
            }
            return false;
        }
    }

    public static final class GroupInstruction
    implements Instruction {
        private final GroupId groupId;

        private GroupInstruction(GroupId groupId) {
            this.groupId = groupId;
        }

        public GroupId groupId() {
            return this.groupId;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.GROUP;
        }

        public String toString() {
            return this.type().toString() + Instructions.SEPARATOR + "0x" + Integer.toHexString(this.groupId.id());
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.groupId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof GroupInstruction) {
                GroupInstruction that = (GroupInstruction)obj;
                return Objects.equals(this.groupId, that.groupId);
            }
            return false;
        }
    }

    public static final class OutputInstruction
    implements Instruction {
        private final PortNumber port;

        private OutputInstruction(PortNumber port) {
            this.port = port;
        }

        public PortNumber port() {
            return this.port;
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.OUTPUT;
        }

        public String toString() {
            return this.type().toString() + Instructions.SEPARATOR + this.port.toString();
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.port);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OutputInstruction) {
                OutputInstruction that = (OutputInstruction)obj;
                return Objects.equals(this.port, that.port);
            }
            return false;
        }
    }

    public static final class NoActionInstruction
    implements Instruction {
        private NoActionInstruction() {
        }

        @Override
        public Instruction.Type type() {
            return Instruction.Type.NOACTION;
        }

        public String toString() {
            return this.type().toString();
        }

        public int hashCode() {
            return this.type().ordinal();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof NoActionInstruction;
        }
    }
}

