/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.core.GroupId;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;

public final class GroupOperation {
    private final Type opType;
    private final GroupId groupId;
    private final GroupDescription.Type groupType;
    private final GroupBuckets buckets;
    private final GroupMsgErrorCode failureCode;

    private GroupOperation(Type opType, GroupId groupId, GroupDescription.Type groupType, GroupBuckets buckets) {
        this.opType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)opType)));
        this.groupId = (GroupId)Preconditions.checkNotNull((Object)groupId);
        this.groupType = (GroupDescription.Type)((Object)Preconditions.checkNotNull((Object)((Object)groupType)));
        this.buckets = buckets;
        this.failureCode = null;
    }

    private GroupOperation(GroupOperation groupOp, GroupMsgErrorCode failureCode) {
        this.opType = groupOp.opType;
        this.groupId = groupOp.groupId;
        this.groupType = groupOp.groupType;
        this.buckets = groupOp.buckets;
        this.failureCode = failureCode;
    }

    public static GroupOperation createAddGroupOperation(GroupId groupId, GroupDescription.Type groupType, GroupBuckets buckets) {
        Preconditions.checkNotNull((Object)buckets);
        return new GroupOperation(Type.ADD, groupId, groupType, buckets);
    }

    public static GroupOperation createModifyGroupOperation(GroupId groupId, GroupDescription.Type groupType, GroupBuckets buckets) {
        Preconditions.checkNotNull((Object)buckets);
        return new GroupOperation(Type.MODIFY, groupId, groupType, buckets);
    }

    public static GroupOperation createDeleteGroupOperation(GroupId groupId, GroupDescription.Type groupType) {
        return new GroupOperation(Type.DELETE, groupId, groupType, null);
    }

    public static GroupOperation createFailedGroupOperation(GroupOperation groupOperation, GroupMsgErrorCode failureCode) {
        Preconditions.checkNotNull((Object)groupOperation);
        return new GroupOperation(groupOperation, failureCode);
    }

    public Type opType() {
        return this.opType;
    }

    public GroupId groupId() {
        return this.groupId;
    }

    public GroupDescription.Type groupType() {
        return this.groupType;
    }

    public GroupBuckets buckets() {
        return this.buckets;
    }

    public GroupMsgErrorCode failureCode() {
        return this.failureCode;
    }

    public int hashCode() {
        return this.buckets != null ? Objects.hash(new Object[]{this.groupId, this.opType, this.buckets}) : Objects.hash(new Object[]{this.groupId, this.opType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GroupOperation) {
            GroupOperation that = (GroupOperation)obj;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals((Object)this.groupType, (Object)that.groupType) && Objects.equals((Object)this.opType, (Object)that.opType) && Objects.equals(this.buckets, that.buckets);
        }
        return false;
    }

    public static enum GroupMsgErrorCode {
        GROUP_EXISTS,
        INVALID_GROUP,
        WEIGHT_UNSUPPORTED,
        OUT_OF_GROUPS,
        OUT_OF_BUCKETS,
        CHAINING_UNSUPPORTED,
        WATCH_UNSUPPORTED,
        LOOP,
        UNKNOWN_GROUP,
        CHAINED_GROUP,
        BAD_TYPE,
        BAD_COMMAND,
        BAD_BUCKET,
        BAD_WATCH,
        EPERM;

    }

    public static enum Type {
        ADD,
        MODIFY,
        DELETE;

    }
}

