/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public final class LinkCollectionIntent
extends ConnectivityIntent {
    private final Set<Link> links;
    private final Set<ConnectPoint> ingressPoints;
    private final Set<ConnectPoint> egressPoints;
    private final boolean egressTreatmentFlag;
    private final Map<ConnectPoint, TrafficSelector> ingressSelectors;
    private final Map<ConnectPoint, TrafficTreatment> egressTreatments;

    private LinkCollectionIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Set<Link> links, Set<ConnectPoint> ingressPoints, Set<ConnectPoint> egressPoints, List<Constraint> constraints, int priority, boolean egressTreatment, Map<ConnectPoint, TrafficSelector> ingressSelectors, Map<ConnectPoint, TrafficTreatment> egressTreatments) {
        super(appId, key, LinkCollectionIntent.resources(links), selector, treatment, constraints, priority);
        this.links = links;
        this.ingressPoints = ingressPoints;
        this.egressPoints = egressPoints;
        this.egressTreatmentFlag = egressTreatment;
        this.ingressSelectors = ingressSelectors;
        this.egressTreatments = egressTreatments;
    }

    protected LinkCollectionIntent() {
        this.links = null;
        this.ingressPoints = null;
        this.egressPoints = null;
        this.egressTreatmentFlag = false;
        this.ingressSelectors = null;
        this.egressTreatments = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<Link> links() {
        return this.links;
    }

    public Set<ConnectPoint> ingressPoints() {
        return this.ingressPoints;
    }

    public Set<ConnectPoint> egressPoints() {
        return this.egressPoints;
    }

    public Map<ConnectPoint, TrafficSelector> ingressSelectors() {
        return this.ingressSelectors;
    }

    public Map<ConnectPoint, TrafficTreatment> egressTreatments() {
        return this.egressTreatments;
    }

    public boolean applyTreatmentOnEgress() {
        return this.egressTreatmentFlag;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("links", this.links()).add("ingress", this.ingressPoints()).add("egress", this.egressPoints()).add("selectors", this.ingressSelectors()).add("treatments", this.egressTreatments()).add("treatementOnEgress", this.applyTreatmentOnEgress()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        Set<Link> links;
        Set<ConnectPoint> ingressPoints;
        Set<ConnectPoint> egressPoints;
        Map<ConnectPoint, TrafficSelector> ingressSelectors = ImmutableMap.of();
        Map<ConnectPoint, TrafficTreatment> egressTreatments = ImmutableMap.of();
        boolean egressTreatmentFlag;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder ingressPoints(Set<ConnectPoint> ingressPoints) {
            this.ingressPoints = ImmutableSet.copyOf(ingressPoints);
            return this;
        }

        public Builder egressPoints(Set<ConnectPoint> egressPoints) {
            this.egressPoints = ImmutableSet.copyOf(egressPoints);
            return this;
        }

        public Builder ingressSelectors(Map<ConnectPoint, TrafficSelector> ingressSelectors) {
            this.ingressSelectors = ImmutableMap.copyOf(ingressSelectors);
            return this;
        }

        public Builder egressTreatments(Map<ConnectPoint, TrafficTreatment> egressTreatments) {
            this.egressTreatments = ImmutableMap.copyOf(egressTreatments);
            return this;
        }

        public Builder links(Set<Link> links) {
            this.links = ImmutableSet.copyOf(links);
            return this;
        }

        public Builder applyTreatmentOnEgress(boolean treatmentOnEgress) {
            this.egressTreatmentFlag = treatmentOnEgress;
            return this;
        }

        public LinkCollectionIntent build() {
            return new LinkCollectionIntent(this.appId, this.key, this.selector, this.treatment, this.links, this.ingressPoints, this.egressPoints, this.constraints, this.priority, this.egressTreatmentFlag, this.ingressSelectors, this.egressTreatments);
        }
    }
}

