/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public final class MultiPointToSinglePointIntent
extends ConnectivityIntent {
    private final Set<ConnectPoint> ingressPoints;
    private final ConnectPoint egressPoint;
    private final Map<ConnectPoint, TrafficSelector> ingressSelectors;

    private MultiPointToSinglePointIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Set<ConnectPoint> ingressPoints, ConnectPoint egressPoint, List<Constraint> constraints, int priority, Map<ConnectPoint, TrafficSelector> ingressSelectors) {
        super(appId, key, (Collection<NetworkResource>)ImmutableSet.of(), selector, treatment, constraints, priority);
        Preconditions.checkNotNull(ingressPoints);
        Preconditions.checkArgument((!ingressPoints.isEmpty() ? 1 : 0) != 0, (Object)"Ingress point set cannot be empty");
        Preconditions.checkNotNull((Object)egressPoint);
        Preconditions.checkArgument((!ingressPoints.contains(egressPoint) ? 1 : 0) != 0, (String)"Set of ingresses should not contain egress (egress: %s)", (Object[])new Object[]{egressPoint});
        this.ingressPoints = Sets.newHashSet(ingressPoints);
        this.egressPoint = egressPoint;
        this.ingressSelectors = ingressSelectors;
    }

    protected MultiPointToSinglePointIntent() {
        this.ingressPoints = null;
        this.egressPoint = null;
        this.ingressSelectors = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MultiPointToSinglePointIntent intent) {
        return new Builder(intent);
    }

    public Set<ConnectPoint> ingressPoints() {
        return this.ingressPoints;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public Map<ConnectPoint, TrafficSelector> ingressSelectors() {
        return this.ingressSelectors;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", this.ingressPoints()).add("egress", (Object)this.egressPoint()).add("selectors", this.ingressSelectors()).add("constraints", this.constraints()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        Set<ConnectPoint> ingressPoints;
        ConnectPoint egressPoint;
        Map<ConnectPoint, TrafficSelector> ingressSelectors = ImmutableMap.of();

        private Builder() {
        }

        protected Builder(MultiPointToSinglePointIntent intent) {
            super(intent);
            this.ingressPoints(intent.ingressPoints()).egressPoint(intent.egressPoint());
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder ingressPoints(Set<ConnectPoint> ingressPoints) {
            this.ingressPoints = ImmutableSet.copyOf(ingressPoints);
            return this;
        }

        public Builder egressPoint(ConnectPoint egressPoint) {
            this.egressPoint = egressPoint;
            return this;
        }

        public Builder selectors(Map<ConnectPoint, TrafficSelector> ingressSelectors) {
            this.ingressSelectors = ImmutableMap.copyOf(ingressSelectors);
            return this;
        }

        public MultiPointToSinglePointIntent build() {
            if (this.selector != null && !this.selector.criteria().isEmpty() && this.ingressSelectors != null && !this.ingressSelectors.isEmpty()) {
                throw new IllegalArgumentException("Selector and Multiple Selectors are both set");
            }
            return new MultiPointToSinglePointIntent(this.appId, this.key, this.selector, this.treatment, this.ingressPoints, this.egressPoint, this.constraints, this.priority, this.ingressSelectors);
        }
    }
}

