/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.stream.Stream;
import org.onlab.util.Bandwidth;
import org.onlab.util.DataRateUnit;
import org.onosproject.net.Link;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.BooleanConstraint;
import org.onosproject.net.resource.Resources;

@Beta
public final class BandwidthConstraint
extends BooleanConstraint {
    private final Bandwidth bandwidth;

    public BandwidthConstraint(Bandwidth bandwidth) {
        this.bandwidth = (Bandwidth)Preconditions.checkNotNull((Object)bandwidth, (Object)"Bandwidth cannot be null");
    }

    public static BandwidthConstraint of(double v, DataRateUnit unit) {
        return new BandwidthConstraint(Bandwidth.of((double)v, (DataRateUnit)unit));
    }

    private BandwidthConstraint() {
        this.bandwidth = null;
    }

    @Override
    public boolean isValid(Link link, ResourceContext context) {
        return Stream.of(link.src(), link.dst()).map(cp -> Resources.continuous(cp.deviceId(), cp.port(), Bandwidth.class).resource(this.bandwidth.bps())).allMatch(context::isAvailable);
    }

    public Bandwidth bandwidth() {
        return this.bandwidth;
    }

    public int hashCode() {
        return this.bandwidth.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BandwidthConstraint other = (BandwidthConstraint)obj;
        return Objects.equals(this.bandwidth, other.bandwidth);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bandwidth", (Object)this.bandwidth).toString();
    }
}

