/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.annotations.Beta;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.intent.ResourceContext;

@Beta
public class ProtectionConstraint
implements Constraint {
    private static final ProtectionConstraint PROTECTION_CONSTRAINT = new ProtectionConstraint();

    @Override
    public double cost(Link link, ResourceContext context) {
        return 1.0;
    }

    @Override
    public boolean validate(Path path, ResourceContext context) {
        return true;
    }

    public static boolean requireProtectedPath(Intent intent) {
        if (intent instanceof PointToPointIntent) {
            PointToPointIntent pointToPointIntent = (PointToPointIntent)intent;
            return pointToPointIntent.constraints().stream().anyMatch(p -> p instanceof ProtectionConstraint);
        }
        return false;
    }

    public static ProtectionConstraint protection() {
        return PROTECTION_CONSTRAINT;
    }

    protected ProtectionConstraint() {
    }

    public String toString() {
        return "Protection";
    }
}

