/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterContext;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterRequest;

public final class DefaultMeterRequest
implements MeterRequest {
    private final ApplicationId appId;
    private final Meter.Unit unit;
    private final boolean burst;
    private final Collection<Band> bands;
    private final DeviceId deviceId;
    private final Optional<MeterContext> context;
    private final MeterRequest.Type op;

    private DefaultMeterRequest(DeviceId deviceId, ApplicationId appId, Meter.Unit unit, boolean burst, Collection<Band> bands, MeterContext context, MeterRequest.Type op) {
        this.deviceId = deviceId;
        this.appId = appId;
        this.unit = unit;
        this.burst = burst;
        this.bands = bands;
        this.context = Optional.ofNullable(context);
        this.op = op;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public Meter.Unit unit() {
        return this.unit;
    }

    @Override
    public boolean isBurst() {
        return this.burst;
    }

    @Override
    public Collection<Band> bands() {
        return this.bands;
    }

    @Override
    public Optional<MeterContext> context() {
        return this.context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("device", (Object)this.deviceId).add("appId", (Object)this.appId.name()).add("unit", (Object)this.unit).add("isBurst", this.burst).add("bands", this.bands).toString();
    }

    public static final class Builder
    implements MeterRequest.Builder {
        private ApplicationId appId;
        private Meter.Unit unit = Meter.Unit.KB_PER_SEC;
        private boolean burst = false;
        private Collection<Band> bands;
        private DeviceId deviceId;
        private MeterContext context;
        private Optional<MeterId> desiredId = Optional.empty();

        @Override
        public MeterRequest.Builder forDevice(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public MeterRequest.Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public MeterRequest.Builder withUnit(Meter.Unit unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public MeterRequest.Builder burst() {
            this.burst = true;
            return this;
        }

        @Override
        public MeterRequest.Builder withBands(Collection<Band> bands) {
            this.bands = ImmutableSet.copyOf(bands);
            return this;
        }

        @Override
        public MeterRequest.Builder withContext(MeterContext context) {
            this.context = context;
            return this;
        }

        @Override
        public MeterRequest add() {
            this.validate();
            return new DefaultMeterRequest(this.deviceId, this.appId, this.unit, this.burst, this.bands, this.context, MeterRequest.Type.ADD);
        }

        @Override
        public MeterRequest remove() {
            this.validate();
            return new DefaultMeterRequest(this.deviceId, this.appId, this.unit, this.burst, this.bands, this.context, MeterRequest.Type.REMOVE);
        }

        private void validate() {
            Preconditions.checkNotNull((Object)this.deviceId, (Object)"Must specify a device");
            Preconditions.checkNotNull(this.bands, (Object)"Must have bands.");
            Preconditions.checkArgument((this.bands.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one band.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must have an application id");
        }
    }
}

