/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.ResourceId;

@Beta
public final class ContinuousResourceId
extends ResourceId {
    private final ImmutableList<Object> components;
    private final String name;

    ContinuousResourceId(ImmutableList.Builder<Object> parentComponents, Class<?> last) {
        this.components = parentComponents.add((Object)last.getCanonicalName()).build();
        this.name = last.getSimpleName();
    }

    ContinuousResourceId() {
        this.components = ImmutableList.of();
        this.name = "";
    }

    @Override
    ImmutableList<Object> components() {
        return this.components;
    }

    @Override
    String simpleTypeName() {
        return this.name;
    }

    @Override
    boolean isTypeOf(Class<?> type) {
        String typeName = (String)this.lastComponent();
        return typeName.equals(type.getCanonicalName());
    }

    @Override
    boolean isSubTypeOf(Class<?> ancestor) {
        String typeName = (String)this.lastComponent();
        boolean foundInLeaf = typeName.equals(ancestor.getCanonicalName());
        boolean foundInAncestor = this.components.subList(0, this.components.size()).stream().filter(x -> ancestor.isAssignableFrom(x.getClass())).findAny().isPresent();
        return foundInAncestor || foundInLeaf;
    }

    @Override
    public DiscreteResourceId child(Object child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContinuousResourceId child(Class<?> child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<DiscreteResourceId> parent() {
        if (this.components.size() == 0) {
            return Optional.empty();
        }
        if (this.components.size() == 1) {
            return Optional.of(ROOT);
        }
        return Optional.of(new DiscreteResourceId((ImmutableList<Object>)this.components.subList(0, this.components.size() - 1)));
    }

    private Object lastComponent() {
        return this.components.get(this.components.size() - 1);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContinuousResourceId other = (ContinuousResourceId)obj;
        return Objects.equals(this.components, other.components);
    }

    public String toString() {
        return ImmutableList.builder().addAll((Iterable)this.components.subList(0, this.components.size() - 1)).add((Object)this.name).build().toString();
    }
}

