/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.statistic;

import com.google.common.base.Preconditions;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTypedFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.TypedStoredFlowEntry;
import org.onosproject.net.statistic.DefaultLoad;
import org.onosproject.net.statistic.Load;

public class TypedFlowEntryWithLoad {
    private ConnectPoint cp;
    private TypedStoredFlowEntry tfe;
    private Load load;
    private static final int CAL_AND_POLL_INTERVAL = 5;
    private static final int MID_POLL_INTERVAL = 10;
    private static final int LONG_POLL_INTERVAL = 15;

    public TypedFlowEntryWithLoad(ConnectPoint cp, TypedStoredFlowEntry tfe, Load load) {
        this.cp = cp;
        this.tfe = tfe;
        this.load = load;
    }

    public TypedFlowEntryWithLoad(ConnectPoint cp, TypedStoredFlowEntry tfe) {
        this.cp = cp;
        this.tfe = tfe;
        this.load = new DefaultLoad(tfe.bytes(), 0L, TypedFlowEntryWithLoad.typedPollInterval(tfe));
    }

    public TypedFlowEntryWithLoad(ConnectPoint cp, FlowEntry fe) {
        this.cp = cp;
        this.tfe = TypedFlowEntryWithLoad.newTypedStoredFlowEntry(fe);
        this.load = new DefaultLoad(fe.bytes(), 0L, TypedFlowEntryWithLoad.typedPollInterval(this.tfe));
    }

    public ConnectPoint connectPoint() {
        return this.cp;
    }

    public TypedStoredFlowEntry typedStoredFlowEntry() {
        return this.tfe;
    }

    public Load load() {
        return this.load;
    }

    public void setLoad(Load load) {
        this.load = load;
    }

    public static int shortPollInterval() {
        return 5;
    }

    public static int midPollInterval() {
        return 10;
    }

    public static int longPollInterval() {
        return 15;
    }

    public static int avgPollInterval() {
        return 10;
    }

    public static long typedPollInterval(TypedStoredFlowEntry tfe) {
        Preconditions.checkNotNull((Object)tfe, (Object)"TypedStoredFlowEntry cannot be null");
        switch (tfe.flowLiveType()) {
            case LONG_FLOW: {
                return 15L;
            }
            case MID_FLOW: {
                return 10L;
            }
        }
        return 5L;
    }

    public static TypedStoredFlowEntry newTypedStoredFlowEntry(FlowEntry fe) {
        if (fe == null) {
            return null;
        }
        long life = fe.life();
        if (life >= 15L) {
            return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.LONG_FLOW);
        }
        if (life >= 10L) {
            return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.MID_FLOW);
        }
        if (life >= 5L) {
            return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.SHORT_FLOW);
        }
        if (life >= 0L) {
            return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.IMMEDIATE_FLOW);
        }
        return new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.UNKNOWN_FLOW);
    }
}

