/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDisjointPath;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.host.HostService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;

public abstract class AbstractPathService
implements PathService {
    private static final String ELEMENT_ID_NULL = "Element ID cannot be null";
    private static final EdgeLink NOT_HOST = new NotHost();
    private static final ProviderId PID = new ProviderId("core", "org.onosproject.core");
    private static final PortNumber P0 = PortNumber.portNumber(0L);
    protected TopologyService topologyService;
    protected HostService hostService;

    @Override
    public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeight weight) {
        DeviceId dstDevice;
        Preconditions.checkNotNull((Object)src, (Object)ELEMENT_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)ELEMENT_ID_NULL);
        EdgeLink srcEdge = this.getEdgeLink(src, true);
        EdgeLink dstEdge = this.getEdgeLink(dst, false);
        if (srcEdge == null || dstEdge == null) {
            return ImmutableSet.of();
        }
        DeviceId srcDevice = srcEdge != NOT_HOST ? srcEdge.dst().deviceId() : (DeviceId)src;
        DeviceId deviceId = dstDevice = dstEdge != NOT_HOST ? dstEdge.src().deviceId() : (DeviceId)dst;
        if (srcDevice.equals(dstDevice)) {
            return this.edgeToEdgePaths(srcEdge, dstEdge);
        }
        Topology topology = this.topologyService.currentTopology();
        Set<Path> paths = weight == null ? this.topologyService.getPaths(topology, srcDevice, dstDevice) : this.topologyService.getPaths(topology, srcDevice, dstDevice, weight);
        return this.edgeToEdgePaths(srcEdge, dstEdge, paths);
    }

    @Override
    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeight weight) {
        DeviceId dstDevice;
        Preconditions.checkNotNull((Object)src, (Object)ELEMENT_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)ELEMENT_ID_NULL);
        EdgeLink srcEdge = this.getEdgeLink(src, true);
        EdgeLink dstEdge = this.getEdgeLink(dst, false);
        if (srcEdge == null || dstEdge == null) {
            return ImmutableSet.of();
        }
        DeviceId srcDevice = srcEdge != NOT_HOST ? srcEdge.dst().deviceId() : (DeviceId)src;
        DeviceId deviceId = dstDevice = dstEdge != NOT_HOST ? dstEdge.src().deviceId() : (DeviceId)dst;
        if (srcDevice.equals(dstDevice)) {
            return this.edgeToEdgePathsDisjoint(srcEdge, dstEdge);
        }
        Topology topology = this.topologyService.currentTopology();
        Set<DisjointPath> paths = weight == null ? this.topologyService.getDisjointPaths(topology, srcDevice, dstDevice) : this.topologyService.getDisjointPaths(topology, srcDevice, dstDevice, weight);
        return this.edgeToEdgePathsDisjoint(srcEdge, dstEdge, paths);
    }

    @Override
    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeight weight, Map<Link, Object> riskProfile) {
        DeviceId dstDevice;
        Preconditions.checkNotNull((Object)src, (Object)ELEMENT_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)ELEMENT_ID_NULL);
        EdgeLink srcEdge = this.getEdgeLink(src, true);
        EdgeLink dstEdge = this.getEdgeLink(dst, false);
        if (srcEdge == null || dstEdge == null) {
            return ImmutableSet.of();
        }
        DeviceId srcDevice = srcEdge != NOT_HOST ? srcEdge.dst().deviceId() : (DeviceId)src;
        DeviceId deviceId = dstDevice = dstEdge != NOT_HOST ? dstEdge.src().deviceId() : (DeviceId)dst;
        if (srcDevice.equals(dstDevice)) {
            return this.edgeToEdgePathsDisjoint(srcEdge, dstEdge);
        }
        Topology topology = this.topologyService.currentTopology();
        Set<DisjointPath> paths = weight == null ? this.topologyService.getDisjointPaths(topology, srcDevice, dstDevice, riskProfile) : this.topologyService.getDisjointPaths(topology, srcDevice, dstDevice, weight, riskProfile);
        return this.edgeToEdgePathsDisjoint(srcEdge, dstEdge, paths);
    }

    private EdgeLink getEdgeLink(ElementId elementId, boolean isIngress) {
        if (elementId instanceof HostId) {
            Host host = this.hostService.getHost((HostId)elementId);
            if (host == null) {
                return null;
            }
            return new DefaultEdgeLink(PID, new ConnectPoint(elementId, P0), host.location(), isIngress, new Annotations[0]);
        }
        return NOT_HOST;
    }

    private Set<Path> edgeToEdgePaths(EdgeLink srcLink, EdgeLink dstLink) {
        HashSet endToEndPaths = Sets.newHashSetWithExpectedSize((int)1);
        endToEndPaths.add(this.edgeToEdgePath(srcLink, dstLink, null));
        return endToEndPaths;
    }

    private Set<Path> edgeToEdgePaths(EdgeLink srcLink, EdgeLink dstLink, Set<Path> paths) {
        HashSet endToEndPaths = Sets.newHashSetWithExpectedSize((int)paths.size());
        for (Path path : paths) {
            endToEndPaths.add(this.edgeToEdgePath(srcLink, dstLink, path));
        }
        return endToEndPaths;
    }

    private Set<DisjointPath> edgeToEdgePathsDisjoint(EdgeLink srcLink, EdgeLink dstLink) {
        HashSet endToEndPaths = Sets.newHashSetWithExpectedSize((int)1);
        endToEndPaths.add(this.edgeToEdgePathD(srcLink, dstLink, null));
        return endToEndPaths;
    }

    private Set<DisjointPath> edgeToEdgePathsDisjoint(EdgeLink srcLink, EdgeLink dstLink, Set<DisjointPath> paths) {
        HashSet endToEndPaths = Sets.newHashSetWithExpectedSize((int)paths.size());
        for (DisjointPath path : paths) {
            endToEndPaths.add(this.edgeToEdgePathD(srcLink, dstLink, path));
        }
        return endToEndPaths;
    }

    private Path edgeToEdgePath(EdgeLink srcLink, EdgeLink dstLink, Path path) {
        ArrayList links = Lists.newArrayListWithCapacity((int)2);
        double cost = 0.0;
        if (srcLink != NOT_HOST) {
            links.add(srcLink);
            cost += 1.0;
        }
        if (path != null) {
            links.addAll(path.links());
            cost += path.cost();
        }
        if (dstLink != NOT_HOST) {
            links.add(dstLink);
            cost += 1.0;
        }
        return new DefaultPath(PID, links, cost, new Annotations[0]);
    }

    private DisjointPath edgeToEdgePathD(EdgeLink srcLink, EdgeLink dstLink, DisjointPath path) {
        Path primary = null;
        Path backup = null;
        if (path != null) {
            primary = path.primary();
            backup = path.backup();
        }
        if (backup == null) {
            return new DefaultDisjointPath(PID, (DefaultPath)this.edgeToEdgePath(srcLink, dstLink, primary));
        }
        return new DefaultDisjointPath(PID, (DefaultPath)this.edgeToEdgePath(srcLink, dstLink, primary), (DefaultPath)this.edgeToEdgePath(srcLink, dstLink, backup));
    }

    private static class NotHost
    extends DefaultEdgeLink
    implements EdgeLink {
        NotHost() {
            super(PID, new ConnectPoint(HostId.NONE, P0), new HostLocation(DeviceId.NONE, P0, 0L), false, new Annotations[0]);
        }
    }
}

