/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.Throwables;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.ConsistentMapBackedJavaMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Synchronous;
import org.onosproject.store.service.Versioned;

public class DefaultConsistentMap<K, V>
extends Synchronous<AsyncConsistentMap<K, V>>
implements ConsistentMap<K, V> {
    private static final int MAX_DELAY_BETWEEN_RETY_MILLS = 50;
    private final AsyncConsistentMap<K, V> asyncMap;
    private final long operationTimeoutMillis;
    private Map<K, V> javaMap;

    public DefaultConsistentMap(AsyncConsistentMap<K, V> asyncMap, long operationTimeoutMillis) {
        super(asyncMap);
        this.asyncMap = asyncMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int size() {
        return this.complete(this.asyncMap.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncMap.isEmpty());
    }

    @Override
    public boolean containsKey(K key) {
        return this.complete(this.asyncMap.containsKey(key));
    }

    @Override
    public boolean containsValue(V value) {
        return this.complete(this.asyncMap.containsValue(value));
    }

    @Override
    public Versioned<V> get(K key) {
        return this.complete(this.asyncMap.get(key));
    }

    @Override
    public Versioned<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIf(key, Objects::isNull, (k, v) -> mappingFunction.apply((Object)k));
    }

    @Override
    public Versioned<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, Objects::nonNull, remappingFunction);
    }

    @Override
    public Versioned<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, v -> true, remappingFunction);
    }

    @Override
    public Versioned<V> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (Versioned)Tools.retryable(() -> this.complete(this.asyncMap.computeIf(key, condition, remappingFunction)), ConsistentMapException.ConcurrentModification.class, (int)Integer.MAX_VALUE, (int)50).get();
    }

    @Override
    public Versioned<V> put(K key, V value) {
        return this.complete(this.asyncMap.put(key, value));
    }

    @Override
    public Versioned<V> putAndGet(K key, V value) {
        return this.complete(this.asyncMap.putAndGet(key, value));
    }

    @Override
    public Versioned<V> remove(K key) {
        return this.complete(this.asyncMap.remove(key));
    }

    @Override
    public void clear() {
        this.complete(this.asyncMap.clear());
    }

    @Override
    public Set<K> keySet() {
        return this.complete(this.asyncMap.keySet());
    }

    @Override
    public Collection<Versioned<V>> values() {
        return this.complete(this.asyncMap.values());
    }

    @Override
    public Set<Map.Entry<K, Versioned<V>>> entrySet() {
        return this.complete(this.asyncMap.entrySet());
    }

    @Override
    public Versioned<V> putIfAbsent(K key, V value) {
        return this.complete(this.asyncMap.putIfAbsent(key, value));
    }

    @Override
    public boolean remove(K key, V value) {
        return this.complete(this.asyncMap.remove(key, value));
    }

    @Override
    public boolean remove(K key, long version) {
        return this.complete(this.asyncMap.remove(key, version));
    }

    @Override
    public Versioned<V> replace(K key, V value) {
        return this.complete(this.asyncMap.replace(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.complete(this.asyncMap.replace(key, oldValue, newValue));
    }

    @Override
    public boolean replace(K key, long oldVersion, V newValue) {
        return this.complete(this.asyncMap.replace(key, oldVersion, newValue));
    }

    @Override
    public void addListener(MapEventListener<K, V> listener, Executor executor) {
        this.complete(this.asyncMap.addListener(listener, executor));
    }

    @Override
    public void removeListener(MapEventListener<K, V> listener) {
        this.complete(this.asyncMap.removeListener(listener));
    }

    @Override
    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.asyncMap.addStatusChangeListener(listener);
    }

    @Override
    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.asyncMap.removeStatusChangeListener(listener);
    }

    @Override
    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return this.asyncMap.statusChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> asJavaMap() {
        DefaultConsistentMap defaultConsistentMap = this;
        synchronized (defaultConsistentMap) {
            if (this.javaMap == null) {
                this.javaMap = new ConsistentMapBackedJavaMap(this);
            }
        }
        return this.javaMap;
    }

    public String toString() {
        return this.asJavaMap().toString();
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsistentMapException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new ConsistentMapException.Timeout(this.name());
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new ConsistentMapException(e.getCause());
        }
    }
}

