/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.primitives.DefaultLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.LeaderElector;

public interface AsyncLeaderElector
extends DistributedPrimitive {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.LEADER_ELECTOR;
    }

    public CompletableFuture<Leadership> run(String var1, NodeId var2);

    public CompletableFuture<Void> withdraw(String var1);

    public CompletableFuture<Boolean> anoint(String var1, NodeId var2);

    public CompletableFuture<Void> evict(NodeId var1);

    public CompletableFuture<Boolean> promote(String var1, NodeId var2);

    public CompletableFuture<Leadership> getLeadership(String var1);

    public CompletableFuture<Map<String, Leadership>> getLeaderships();

    public CompletableFuture<Void> addChangeListener(Consumer<Change<Leadership>> var1);

    public CompletableFuture<Void> removeChangeListener(Consumer<Change<Leadership>> var1);

    default public LeaderElector asLeaderElector(long timeoutMillis) {
        return new DefaultLeaderElector(this, timeoutMillis);
    }

    default public LeaderElector asLeaderElector() {
        return this.asLeaderElector(5000L);
    }
}

