/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.onosproject.store.service.IllegalDocumentNameException;

public class DocumentPath
implements Comparable<DocumentPath> {
    private final List<String> pathElements = Lists.newArrayList();

    private DocumentPath(List<String> pathElements) {
        Preconditions.checkNotNull(pathElements);
        this.pathElements.addAll(pathElements);
    }

    public DocumentPath(String nodeName, DocumentPath parentPath) {
        if (nodeName.contains(".")) {
            throw new IllegalDocumentNameException("Periods are not allowed in names.");
        }
        if (parentPath != null) {
            this.pathElements.addAll(parentPath.pathElements());
        }
        if (nodeName != null) {
            this.pathElements.add(nodeName);
        }
        if (this.pathElements.isEmpty()) {
            throw new IllegalDocumentNameException("A document path must contain atleast one non-nullelement.");
        }
    }

    public static DocumentPath from(String path) {
        return new DocumentPath(Arrays.asList(path.split("\\.")));
    }

    public DocumentPath parent() {
        if (this.pathElements.size() <= 1) {
            return null;
        }
        return new DocumentPath(this.pathElements.subList(0, this.pathElements.size() - 1));
    }

    public List<String> pathElements() {
        return ImmutableList.copyOf(this.pathElements);
    }

    public int hashCode() {
        return Objects.hash(this.pathElements);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DocumentPath) {
            DocumentPath that = (DocumentPath)obj;
            return this.pathElements.equals(that.pathElements);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iter = this.pathElements.iterator();
        while (iter.hasNext()) {
            stringBuilder.append(iter.next());
            if (!iter.hasNext()) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(DocumentPath that) {
        int shorterLength = this.pathElements.size() > that.pathElements.size() ? that.pathElements.size() : this.pathElements.size();
        for (int i = 0; i < shorterLength; ++i) {
            if (this.pathElements.get(i).compareTo(that.pathElements.get(i)) == 0) continue;
            return this.pathElements.get(i).compareTo(that.pathElements.get(i));
        }
        if (this.pathElements.size() > that.pathElements.size()) {
            return 1;
        }
        if (that.pathElements.size() > this.pathElements.size()) {
            return -1;
        }
        return 0;
    }
}

