/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;

public class MapTransaction<K, V> {
    private final TransactionId transactionId;
    private final List<MapUpdate<K, V>> updates;

    public MapTransaction(TransactionId transactionId, List<MapUpdate<K, V>> updates) {
        this.transactionId = transactionId;
        this.updates = ImmutableList.copyOf(updates);
    }

    public TransactionId transactionId() {
        return this.transactionId;
    }

    public List<MapUpdate<K, V>> updates() {
        return this.updates;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("transactionId", (Object)this.transactionId).add("updates", this.updates).toString();
    }

    public <S, T> MapTransaction<S, T> map(Function<K, S> keyMapper, Function<V, T> valueMapper) {
        return new MapTransaction<K, V>(this.transactionId, Lists.transform(this.updates, u -> u.map(keyMapper, valueMapper)));
    }
}

