/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiTopoMapFactory;
import org.onosproject.ui.UiTopoOverlayFactory;
import org.onosproject.ui.UiView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UiExtension {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String VIEW_PREFIX = "app/view/";
    private static final String EMPTY = "";
    private static final String SLASH = "/";
    private static final String CSS_HTML = "css.html";
    private static final String JS_HTML = "js.html";
    private final ClassLoader classLoader;
    private final String resourcePath;
    private final List<UiView> views;
    private final UiMessageHandlerFactory messageHandlerFactory;
    private final UiTopoOverlayFactory topoOverlayFactory;
    private final UiTopoMapFactory topoMapFactory;
    private boolean isValid = true;

    private UiExtension(ClassLoader cl, String path, List<UiView> views, UiMessageHandlerFactory mhFactory, UiTopoOverlayFactory toFactory, UiTopoMapFactory tmFactory) {
        this.classLoader = cl;
        this.resourcePath = path;
        this.views = views;
        this.messageHandlerFactory = mhFactory;
        this.topoOverlayFactory = toFactory;
        this.topoMapFactory = tmFactory;
    }

    public InputStream css() {
        return this.getStream(this.resourcePath + CSS_HTML);
    }

    public InputStream js() {
        return this.getStream(this.resourcePath + JS_HTML);
    }

    public List<UiView> views() {
        return this.isValid ? this.views : ImmutableList.of();
    }

    public InputStream resource(String viewId, String path) {
        return this.getStream(VIEW_PREFIX + viewId + SLASH + path);
    }

    public UiMessageHandlerFactory messageHandlerFactory() {
        return this.messageHandlerFactory;
    }

    public UiTopoOverlayFactory topoOverlayFactory() {
        return this.topoOverlayFactory;
    }

    public UiTopoMapFactory topoMapFactory() {
        return this.topoMapFactory;
    }

    private InputStream getStream(String path) {
        InputStream stream = this.classLoader.getResourceAsStream(path);
        if (stream == null) {
            this.isValid = false;
            this.log.warn("Unable to find resource {}", (Object)path);
        }
        return stream;
    }

    public static class Builder {
        private ClassLoader classLoader;
        private String resourcePath = "";
        private List<UiView> views = new ArrayList<UiView>();
        private UiMessageHandlerFactory messageHandlerFactory = null;
        private UiTopoOverlayFactory topoOverlayFactory = null;
        private UiTopoMapFactory topoMapFactory = null;

        public Builder(ClassLoader cl, List<UiView> views) {
            Preconditions.checkNotNull((Object)cl, (Object)"Must provide a class loader");
            Preconditions.checkArgument((views.size() > 0 ? 1 : 0) != 0, (Object)"Must provide at least one view");
            this.classLoader = cl;
            this.views = views;
        }

        public Builder resourcePath(String path) {
            this.resourcePath = path == null ? UiExtension.EMPTY : path + UiExtension.SLASH;
            return this;
        }

        public Builder messageHandlerFactory(UiMessageHandlerFactory mhFactory) {
            this.messageHandlerFactory = mhFactory;
            return this;
        }

        public Builder topoOverlayFactory(UiTopoOverlayFactory toFactory) {
            this.topoOverlayFactory = toFactory;
            return this;
        }

        public Builder topoMapFactory(UiTopoMapFactory tmFactory) {
            this.topoMapFactory = tmFactory;
            return this;
        }

        public UiExtension build() {
            return new UiExtension(this.classLoader, this.resourcePath, this.views, this.messageHandlerFactory, this.topoOverlayFactory, this.topoMapFactory);
        }
    }
}

