/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.chart;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.chart.ChartModel;
import org.onosproject.ui.chart.ChartUtils;

public abstract class ChartRequestHandler
extends RequestHandler {
    private final String respType;
    private final String nodeName;
    protected static final String LABEL = "label";
    private static final String ANNOTS = "annots";

    public ChartRequestHandler(String reqType, String respType, String nodeName) {
        super(reqType);
        this.respType = respType;
        this.nodeName = nodeName;
    }

    @Override
    public void process(long sid, ObjectNode payload) {
        ChartModel cm = this.createChartModel();
        this.populateChart(cm, payload);
        ObjectNode rootNode = MAPPER.createObjectNode();
        rootNode.set(this.nodeName, (JsonNode)ChartUtils.generateDataPointArrayNode(cm));
        rootNode.set(ANNOTS, (JsonNode)ChartUtils.generateAnnotObjectNode(cm));
        this.sendMessage(this.respType, 0L, rootNode);
    }

    protected ChartModel createChartModel() {
        ArrayList<String> series = new ArrayList<String>();
        series.addAll(Arrays.asList(this.getSeries()));
        series.add(LABEL);
        String[] seiresArray = new String[series.size()];
        return new ChartModel(series.toArray(seiresArray));
    }

    protected abstract String[] getSeries();

    protected abstract void populateChart(ChartModel var1, ObjectNode var2);
}

