/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.onosproject.net.DeviceId;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.PortNumber;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiTopology;

public class UiEdgeLink
extends UiLink {
    private static final String E_UNASSOC = "backing link not associated with this UI edge link: ";
    private DeviceId edgeDevice;
    private PortNumber edgePort;
    private EdgeLink edgeLink;

    public UiEdgeLink(UiTopology topology, UiLinkId id) {
        super(topology, id);
    }

    @Override
    public String endPointA() {
        return this.edgeLink.hostId().toString();
    }

    @Override
    public String endPointB() {
        return this.edgeDevice + "/" + this.edgePort;
    }

    @Override
    public String endPortB() {
        return this.edgePort.toString();
    }

    @Override
    protected void destroy() {
        this.edgeDevice = null;
        this.edgePort = null;
        this.edgeLink = null;
    }

    public void attachEdgeLink(EdgeLink elink) {
        UiLinkId.Direction d = this.id.directionOf(elink);
        if (d == null) {
            throw new IllegalArgumentException(E_UNASSOC + elink);
        }
        this.edgeLink = elink;
        this.edgeDevice = elink.hostLocation().deviceId();
        this.edgePort = elink.hostLocation().port();
    }
}

