/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiNode;
import org.onosproject.ui.model.topo.UiTopology;

public class UiRegion
extends UiNode {
    private static final String NULL_NAME = "(root)";
    private static final String NO_NAME = "???";
    public static final RegionId NULL_ID = RegionId.regionId("(root)");
    private static final String[] DEFAULT_LAYER_TAGS = new String[]{"opt", "pkt", "def"};
    private final Set<DeviceId> deviceIds = new HashSet<DeviceId>();
    private final Set<HostId> hostIds = new HashSet<HostId>();
    private final List<String> layerOrder = new ArrayList<String>();
    private final UiTopology topology;
    private final Region region;
    private RegionId parent;
    private final Set<RegionId> kids = new HashSet<RegionId>();

    public UiRegion(UiTopology topology, Region region) {
        this.topology = topology;
        this.region = region;
        this.setLayerOrder(DEFAULT_LAYER_TAGS);
    }

    @Override
    protected void destroy() {
        this.deviceIds.clear();
        this.hostIds.clear();
    }

    public void setLayerOrder(String ... layers) {
        this.layerOrder.clear();
        Collections.addAll(this.layerOrder, layers);
    }

    public RegionId id() {
        return this.region == null ? NULL_ID : this.region.id();
    }

    public RegionId parent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.id().equals((Object)this.parent);
    }

    public Set<RegionId> children() {
        return ImmutableSet.copyOf(this.kids);
    }

    public UiRegion parentRegion() {
        return this.topology.findRegion(this.parent);
    }

    public void setParent(RegionId parentId) {
        this.parent = parentId;
    }

    public void setChildren(Set<RegionId> children) {
        this.kids.clear();
        this.kids.addAll(children);
    }

    @Override
    public String idAsString() {
        return this.id().toString();
    }

    @Override
    public String name() {
        return this.region == null ? NULL_NAME : this.region.name();
    }

    public Region backingRegion() {
        return this.region;
    }

    public void reconcileDevices(Set<DeviceId> devices) {
        this.deviceIds.clear();
        this.deviceIds.addAll(devices);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("name", (Object)this.name()).add("parent", (Object)this.parent).add("kids", this.kids).add("devices", this.deviceIds).add("#hosts", this.hostIds.size()).toString();
    }

    public Region.Type type() {
        return this.region == null ? null : this.region.type();
    }

    public int deviceCount() {
        return this.deviceIds.size();
    }

    public Set<DeviceId> deviceIds() {
        return ImmutableSet.copyOf(this.deviceIds);
    }

    public Set<UiDevice> devices() {
        return this.topology.deviceSet(this.deviceIds);
    }

    public Set<HostId> hostIds() {
        return ImmutableSet.copyOf(this.hostIds);
    }

    public Set<UiHost> hosts() {
        return this.topology.hostSet(this.hostIds);
    }

    public List<String> layerOrder() {
        return Collections.unmodifiableList(this.layerOrder);
    }

    public static String safeName(Region region) {
        if (region == null) {
            return NULL_NAME;
        }
        String name = region.name();
        return Strings.isNullOrEmpty((String)name) ? NO_NAME : name;
    }
}

