/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.collect.ImmutableSet;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.DefaultHostDescription;

public class DefaultHostDecriptionTest {
    private static final MacAddress MAC = MacAddress.valueOf((String)"00:00:11:00:00:01");
    private static final VlanId VLAN = VlanId.vlanId((short)10);
    private static final IpAddress IP = IpAddress.valueOf((String)"10.0.0.1");
    private static final HostLocation LOC = new HostLocation(DeviceId.deviceId((String)"of:foo"), PortNumber.portNumber((long)100L), 123L);

    @Test
    public void basics() {
        DefaultHostDescription host = new DefaultHostDescription(MAC, VLAN, LOC, IP, new SparseAnnotations[0]);
        Assert.assertEquals((String)"incorrect mac", (Object)MAC, (Object)host.hwAddress());
        Assert.assertEquals((String)"incorrect vlan", (Object)VLAN, (Object)host.vlan());
        Assert.assertEquals((String)"incorrect location", (Object)LOC, (Object)host.location());
        Assert.assertEquals((String)"incorrect ip's", (Object)ImmutableSet.of((Object)IP), (Object)host.ipAddress());
        Assert.assertTrue((String)"incorrect toString", (boolean)host.toString().contains("vlan=10"));
    }
}

