/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;

public class MultiPointToSinglePointIntentTest
extends ConnectivityIntentTest {
    @Test
    public void checkImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(MultiPointToSinglePointIntent.class);
    }

    @Test
    public void basics() {
        MultiPointToSinglePointIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)PS1, (Object)intent.ingressPoints());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.egressPoint());
        intent = this.createAnother();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)PS2, (Object)intent.ingressPoints());
        Assert.assertEquals((String)"incorrect egress", (Object)P1, (Object)intent.egressPoint());
        intent = this.createVlanMatch();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)VLANMATCH1, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)PS1, (Object)intent.ingressPoints());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.egressPoint());
    }

    @Test
    public void filteredIntent() {
        MultiPointToSinglePointIntent intent = this.createFilteredOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect filtered ingress", (Object)FPS1, (Object)intent.filteredIngressPoints());
        Assert.assertEquals((String)"incorrect filtered egress", (Object)FP2, (Object)intent.filteredEgressPoint());
        intent = this.createAnotherFiltered();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect filtered ingress", (Object)FPS2, (Object)intent.filteredIngressPoints());
        Assert.assertEquals((String)"incorrect filtered egress", (Object)FP1, (Object)intent.filteredEgressPoint());
    }

    protected MultiPointToSinglePointIntent createOne() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoints(PS1).egressPoint(P2).build();
    }

    protected MultiPointToSinglePointIntent createAnother() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoints(PS2).egressPoint(P1).build();
    }

    protected MultiPointToSinglePointIntent createVlanMatch() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(VLANMATCH1).treatment(NOP).ingressPoints(PS1).egressPoint(P2).build();
    }

    protected MultiPointToSinglePointIntent createFilteredOne() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).treatment(NOP).filteredIngressPoints(FPS1).filteredEgressPoint(FP2).build();
    }

    protected MultiPointToSinglePointIntent createAnotherFiltered() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).treatment(NOP).filteredIngressPoints(FPS2).filteredEgressPoint(FP1).build();
    }

    protected MultiPointToSinglePointIntent createWrongIntent() {
        return MultiPointToSinglePointIntent.builder().appId(APPID).selector(VLANMATCH1).treatment(NOP).filteredIngressPoints(FPS1).filteredEgressPoint(FP2).build();
    }
}

