/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.intent.PointToPointIntent;

public class PointToPointIntentTest
extends ConnectivityIntentTest {
    @Test
    public void checkImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(PointToPointIntent.class);
    }

    @Test
    public void basics() {
        PointToPointIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.ingressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.egressPoint());
    }

    @Test
    public void filtered() {
        PointToPointIntent intent = this.createOneFiltered();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)FP1, (Object)intent.filteredIngressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)FP2, (Object)intent.filteredEgressPoint());
    }

    protected PointToPointIntent createOne() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoint(P1).egressPoint(P2).build();
    }

    protected PointToPointIntent createAnother() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).ingressPoint(P2).egressPoint(P1).build();
    }

    protected PointToPointIntent createOneFiltered() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(FP1).filteredEgressPoint(FP2).build();
    }
}

