/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.key;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.key.CommunityName;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.UsernamePassword;

public class DeviceKeyTest {
    final String deviceKeyIdValue = "DeviceKeyId1";
    final String deviceKeyLabel = "DeviceKeyLabel";
    final String deviceKeySnmpName = "DeviceKeySnmpName";
    final String deviceKeyUsername = "DeviceKeyUsername";
    final String deviceKeyPassword = "DeviceKeyPassword";

    @Test(expected=NullPointerException.class)
    public void testCreateDeviceKeyUsingCommunityNameWithNull() {
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingCommunityName(null, null, null);
    }

    @Test
    public void testCreateDeviceKeyUsingCommunityName() {
        DeviceKeyId deviceKeyId = DeviceKeyId.deviceKeyId((String)"DeviceKeyId1");
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)deviceKeyId, (String)"DeviceKeyLabel", (String)"DeviceKeySnmpName");
        Assert.assertNotNull((String)"The deviceKey should not be null.", (Object)deviceKey);
        Assert.assertEquals((String)"The deviceKeyId should match as expected", (Object)deviceKeyId, (Object)deviceKey.deviceKeyId());
        Assert.assertEquals((String)"The label should match as expected", (Object)"DeviceKeyLabel", (Object)deviceKey.label());
        Assert.assertEquals((String)"The type should match as expected", (Object)DeviceKey.Type.COMMUNITY_NAME, (Object)deviceKey.type());
        CommunityName communityName = deviceKey.asCommunityName();
        Assert.assertNotNull((String)"The communityName should not be null.", (Object)communityName);
        Assert.assertEquals((String)"The name should match as expected", (Object)"DeviceKeySnmpName", (Object)communityName.name());
    }

    @Test(expected=IllegalStateException.class)
    public void testInvalidConversionToAsUsernamePassword() {
        DeviceKeyId deviceKeyId = DeviceKeyId.deviceKeyId((String)"DeviceKeyId1");
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)deviceKeyId, (String)"DeviceKeyLabel", (String)"DeviceKeySnmpName");
        UsernamePassword usernamePassword = deviceKey.asUsernamePassword();
    }

    @Test(expected=NullPointerException.class)
    public void testCreateDeviceKeyUsingUsernamePasswordWithNull() {
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingUsernamePassword(null, null, null, null);
    }

    @Test
    public void testCreateDeviceKeyUsingUsernamePassword() {
        DeviceKeyId deviceKeyId = DeviceKeyId.deviceKeyId((String)"DeviceKeyId1");
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingUsernamePassword((DeviceKeyId)deviceKeyId, (String)"DeviceKeyLabel", (String)"DeviceKeyUsername", (String)"DeviceKeyPassword");
        Assert.assertNotNull((String)"The deviceKey should not be null.", (Object)deviceKey);
        Assert.assertEquals((String)"The deviceKeyId should match as expected", (Object)deviceKeyId, (Object)deviceKey.deviceKeyId());
        Assert.assertEquals((String)"The label should match as expected", (Object)"DeviceKeyLabel", (Object)deviceKey.label());
        Assert.assertEquals((String)"The type should match as expected", (Object)DeviceKey.Type.USERNAME_PASSWORD, (Object)deviceKey.type());
        UsernamePassword usernamePassword = deviceKey.asUsernamePassword();
        Assert.assertNotNull((String)"The usernamePassword should not be null.", (Object)usernamePassword);
        Assert.assertEquals((String)"The username should match as expected", (Object)"DeviceKeyUsername", (Object)usernamePassword.username());
        Assert.assertEquals((String)"The password should match as expected", (Object)"DeviceKeyPassword", (Object)usernamePassword.password());
    }

    @Test(expected=IllegalStateException.class)
    public void testInvalidConversionToAsCommunityName() {
        DeviceKeyId deviceKeyId = DeviceKeyId.deviceKeyId((String)"DeviceKeyId1");
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingUsernamePassword((DeviceKeyId)deviceKeyId, (String)"DeviceKeyLabel", (String)"DeviceKeyUsername", (String)"DeviceKeyPassword");
        CommunityName communityName = deviceKey.asCommunityName();
    }
}

