/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.store.service.DocumentPath;

public class DocumentPathTest {
    @Test
    public void testConstruction() {
        DocumentPath path = DocumentPath.from((String)"root.a.b");
        Assert.assertEquals((Object)path.pathElements(), Arrays.asList("root", "a", "b"));
        Assert.assertEquals((Object)DocumentPath.from((String)"root.a"), (Object)path.parent());
    }

    @Test
    public void testAncestry() {
        DocumentPath path1 = DocumentPath.from((String)"root.a.b");
        DocumentPath path2 = DocumentPath.from((String)"root.a.d");
        DocumentPath path3 = DocumentPath.from((String)"root.a.b.c");
        DocumentPath lca = DocumentPath.leastCommonAncestor(Arrays.asList(path1, path2, path3));
        Assert.assertEquals((Object)DocumentPath.from((String)"root.a"), (Object)lca);
        Assert.assertTrue((boolean)path1.isAncestorOf(path3));
        Assert.assertFalse((boolean)path1.isAncestorOf(path2));
        Assert.assertTrue((boolean)path3.isDescendentOf(path3));
        Assert.assertTrue((boolean)path3.isDescendentOf(path1));
        Assert.assertFalse((boolean)path3.isDescendentOf(path2));
    }
}

