/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.InvalidFieldException;

@Beta
public abstract class Config<S> {
    private static final String TRUE_LITERAL = "true";
    private static final String FALSE_LITERAL = "false";
    protected S subject;
    protected String key;
    protected JsonNode node;
    protected ObjectNode object;
    protected ArrayNode array;
    protected ObjectMapper mapper;
    protected ConfigApplyDelegate delegate;

    public final void init(S subject, String key, JsonNode node, ObjectMapper mapper, ConfigApplyDelegate delegate) {
        this.subject = Preconditions.checkNotNull(subject, (Object)"Subject cannot be null");
        this.key = key;
        this.node = (JsonNode)Preconditions.checkNotNull((Object)node, (Object)"Node cannot be null");
        this.object = node instanceof ObjectNode ? (ObjectNode)node : null;
        this.array = node instanceof ArrayNode ? (ArrayNode)node : null;
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"Mapper cannot be null");
        this.delegate = delegate;
    }

    public boolean isValid() {
        return true;
    }

    public S subject() {
        return this.subject;
    }

    public String key() {
        return this.key;
    }

    public JsonNode node() {
        return this.node;
    }

    public void apply() {
        Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Cannot apply detached config");
        this.delegate.onApply(this);
    }

    protected String get(String name, String defaultValue) {
        return this.object.path(name).asText(defaultValue);
    }

    protected Config<S> setOrClear(String name, String value) {
        if (value != null) {
            this.object.put(name, value);
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected boolean get(String name, boolean defaultValue) {
        return this.object.path(name).asBoolean(defaultValue);
    }

    protected Config<S> clear(String name) {
        this.object.remove(name);
        return this;
    }

    protected Config<S> setOrClear(String name, Boolean value) {
        if (value != null) {
            this.object.put(name, value.booleanValue());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected int get(String name, int defaultValue) {
        return this.object.path(name).asInt(defaultValue);
    }

    protected Config<S> setOrClear(String name, Integer value) {
        if (value != null) {
            this.object.put(name, value.intValue());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected long get(String name, long defaultValue) {
        return this.object.path(name).asLong(defaultValue);
    }

    protected Config<S> setOrClear(String name, Long value) {
        if (value != null) {
            this.object.put(name, value.longValue());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected double get(String name, double defaultValue) {
        return this.object.path(name).asDouble(defaultValue);
    }

    protected Config<S> setOrClear(String name, Double value) {
        if (value != null) {
            this.object.put(name, value.doubleValue());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected <E extends Enum<E>> E get(String name, E defaultValue, Class<E> enumClass) {
        if (defaultValue != null) {
            return Enum.valueOf(enumClass, this.object.path(name).asText(defaultValue.toString()));
        }
        JsonNode node = this.object.get(name);
        return node == null ? null : (E)Enum.valueOf(enumClass, node.asText());
    }

    protected <E extends Enum> Config<S> setOrClear(String name, E value) {
        if (value != null) {
            this.object.put(name, value.toString());
        } else {
            this.object.remove(name);
        }
        return this;
    }

    protected <T> List<T> getList(String name, Function<String, T> function) {
        ArrayList list = Lists.newArrayList();
        ArrayNode arrayNode = (ArrayNode)this.object.path(name);
        arrayNode.forEach(i -> list.add(function.apply(i.asText())));
        return list;
    }

    protected <T> List<T> getList(String name, Function<String, T> function, List<T> defaultValue) {
        ArrayList list = Lists.newArrayList();
        JsonNode jsonNode = this.object.path(name);
        if (jsonNode.isMissingNode()) {
            return defaultValue;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        arrayNode.forEach(i -> list.add(function.apply(i.asText())));
        return list;
    }

    protected <T> Config<S> setOrClear(String name, Collection<T> collection) {
        if (collection == null) {
            this.object.remove(name);
        } else {
            ArrayNode arrayNode = this.mapper.createArrayNode();
            collection.forEach(i -> arrayNode.add(i.toString()));
            this.object.set(name, (JsonNode)arrayNode);
        }
        return this;
    }

    protected boolean hasField(String name) {
        return this.hasField(this.object, name);
    }

    protected boolean hasField(ObjectNode node, String name) {
        Iterator fnames = node.fieldNames();
        while (fnames.hasNext()) {
            if (!((String)fnames.next()).equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOnlyFields(String ... allowedFields) {
        return this.hasOnlyFields(this.object, allowedFields);
    }

    protected boolean hasOnlyFields(ObjectNode node, String ... allowedFields) {
        ImmutableSet fields = ImmutableSet.copyOf((Object[])allowedFields);
        node.fieldNames().forEachRemaining(arg_0 -> Config.lambda$hasOnlyFields$3((Set)fields, arg_0));
        return true;
    }

    protected boolean hasFields(String ... mandatoryFields) {
        return this.hasFields(this.object, mandatoryFields);
    }

    protected boolean hasFields(ObjectNode node, String ... mandatoryFields) {
        ImmutableSet fields = ImmutableSet.copyOf((Object[])mandatoryFields);
        fields.forEach(f -> {
            if (node.path(f).isMissingNode()) {
                throw new InvalidFieldException((String)f, "Mandatory field is not present");
            }
        });
        return true;
    }

    protected boolean isMacAddress(String field, FieldPresence presence) {
        return this.isMacAddress(this.object, field, presence);
    }

    protected boolean isMacAddress(ObjectNode objectNode, String field, FieldPresence presence) {
        return this.isValid(objectNode, field, presence, n -> {
            MacAddress.valueOf((String)n.asText());
            return true;
        });
    }

    protected boolean isIpAddress(String field, FieldPresence presence) {
        return this.isIpAddress(this.object, field, presence);
    }

    protected boolean isIpAddress(ObjectNode objectNode, String field, FieldPresence presence) {
        return this.isValid(objectNode, field, presence, n -> {
            IpAddress.valueOf((String)n.asText());
            return true;
        });
    }

    protected boolean isIpPrefix(String field, FieldPresence presence) {
        return this.isIpPrefix(this.object, field, presence);
    }

    protected boolean isIpPrefix(ObjectNode objectNode, String field, FieldPresence presence) {
        return this.isValid(objectNode, field, presence, n -> {
            IpPrefix.valueOf((String)n.asText());
            return true;
        });
    }

    protected boolean isTpPort(String field, FieldPresence presence) {
        return this.isTpPort(this.object, field, presence);
    }

    protected boolean isTpPort(ObjectNode objectNode, String field, FieldPresence presence) {
        return this.isValid(objectNode, field, presence, n -> {
            TpPort.tpPort((int)n.asInt());
            return true;
        });
    }

    protected boolean isConnectPoint(String field, FieldPresence presence) {
        return this.isConnectPoint(this.object, field, presence);
    }

    protected boolean isConnectPoint(ObjectNode objectNode, String field, FieldPresence presence) {
        return this.isValid(objectNode, field, presence, n -> {
            ConnectPoint.deviceConnectPoint(n.asText());
            return true;
        });
    }

    protected boolean isString(String field, FieldPresence presence, String ... pattern) {
        return this.isString(this.object, field, presence, pattern);
    }

    protected boolean isString(ObjectNode objectNode, String field, FieldPresence presence, String ... pattern) {
        return this.isValid(objectNode, field, presence, node -> {
            if (!node.isTextual() || (pattern.length <= 0 || !node.asText().matches(pattern[0])) && pattern.length >= 1) {
                Config.fail("Invalid string value");
            }
            return true;
        });
    }

    protected boolean isNumber(String field, FieldPresence presence, long ... minMax) {
        return this.isNumber(this.object, field, presence, minMax);
    }

    protected boolean isNumber(ObjectNode objectNode, String field, FieldPresence presence, long ... minMax) {
        return this.isValid(objectNode, field, presence, n -> {
            long number;
            long l = number = n.isNumber() ? n.asLong() : Long.parseLong(n.asText());
            if (minMax.length > 1) {
                Config.verifyRange(number, minMax[0], minMax[1]);
            } else if (minMax.length > 0) {
                Config.verifyRange(number, minMax[0]);
            }
            return true;
        });
    }

    protected boolean isIntegralNumber(String field, FieldPresence presence, long ... minMax) {
        return this.isIntegralNumber(this.object, field, presence, minMax);
    }

    protected boolean isIntegralNumber(ObjectNode objectNode, String field, FieldPresence presence, long ... minMax) {
        return this.isValid(objectNode, field, presence, n -> {
            long number;
            long l = number = n.isIntegralNumber() ? n.asLong() : Long.parseLong(n.asText());
            if (minMax.length > 1) {
                Config.verifyRange(number, minMax[0], minMax[1]);
            } else if (minMax.length > 0) {
                Config.verifyRange(number, minMax[0]);
            }
            return true;
        });
    }

    protected boolean isDecimal(String field, FieldPresence presence, double ... minMax) {
        return this.isDecimal(this.object, field, presence, minMax);
    }

    protected boolean isDecimal(ObjectNode objectNode, String field, FieldPresence presence, double ... minMax) {
        return this.isValid(objectNode, field, presence, n -> {
            double number;
            double d = number = n.isDouble() ? n.asDouble() : Double.parseDouble(n.asText());
            if (minMax.length > 1) {
                Config.verifyRange(number, minMax[0], minMax[1]);
            } else if (minMax.length > 0) {
                Config.verifyRange(number, minMax[0]);
            }
            return true;
        });
    }

    protected boolean isBoolean(String field, FieldPresence presence) {
        return this.isBoolean(this.object, field, presence);
    }

    protected boolean isBoolean(ObjectNode objectNode, String field, FieldPresence presence) {
        return this.isValid(objectNode, field, presence, n -> {
            if (!(n.isBoolean() || n.isTextual() && this.isBooleanString(n.asText()))) {
                Config.fail("Field is not a boolean value");
            }
            return true;
        });
    }

    private boolean isBooleanString(String str) {
        return str.equalsIgnoreCase(TRUE_LITERAL) || str.equalsIgnoreCase(FALSE_LITERAL);
    }

    private boolean isValid(ObjectNode objectNode, String field, FieldPresence presence, Function<JsonNode, Boolean> validationFunction) {
        boolean isMandatory;
        JsonNode node = objectNode.path(field);
        boolean bl = isMandatory = presence == FieldPresence.MANDATORY;
        if (isMandatory && node.isMissingNode()) {
            throw new InvalidFieldException(field, "Mandatory field not present");
        }
        if (!isMandatory && (node.isNull() || node.isMissingNode())) {
            return true;
        }
        try {
            if (validationFunction.apply(node).booleanValue()) {
                return true;
            }
            throw new InvalidFieldException(field, "Validation error");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFieldException(field, e);
        }
    }

    private static void fail(String message) {
        throw new IllegalArgumentException(message);
    }

    private static <N extends Comparable> void verifyRange(N num, N min) {
        if (num.compareTo(min) < 0) {
            Config.fail("Field must be greater than " + min);
        }
    }

    private static <N extends Comparable> void verifyRange(N num, N min, N max) {
        Config.verifyRange(num, min);
        if (num.compareTo(max) > 0) {
            Config.fail("Field must be less than " + max);
        }
    }

    private static /* synthetic */ void lambda$hasOnlyFields$3(Set fields, String f) {
        if (!fields.contains(f)) {
            throw new InvalidFieldException(f, "Field is not allowed");
        }
    }

    public static enum FieldPresence {
        OPTIONAL,
        MANDATORY;

    }
}

