/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;

public final class BasicRegionConfig
extends Config<RegionId> {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String DEVICES = "devices";

    @Override
    public boolean isValid() {
        return this.hasOnlyFields(NAME, TYPE, DEVICES);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(NAME, (Object)this.name()).add(TYPE, (Object)this.type()).add(DEVICES, this.devices()).toString();
    }

    public String name() {
        return this.get(NAME, null);
    }

    public BasicRegionConfig name(String name) {
        return (BasicRegionConfig)this.setOrClear(NAME, name);
    }

    public Region.Type type() {
        String t = this.get(TYPE, null);
        return t == null ? null : this.regionTypeFor(t);
    }

    private Region.Type regionTypeFor(String t) {
        try {
            return Region.Type.valueOf(t.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public BasicRegionConfig type(Region.Type type) {
        String t = type == null ? null : type.name().toLowerCase();
        return (BasicRegionConfig)this.setOrClear(TYPE, t);
    }

    public List<DeviceId> devices() {
        return this.object.has(DEVICES) ? this.getList(DEVICES, DeviceId::deviceId) : null;
    }

    public BasicRegionConfig devices(Set<DeviceId> devices) {
        return (BasicRegionConfig)this.setOrClear(DEVICES, devices);
    }
}

