/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PathIntent;

@Beta
public class FlowRuleIntent
extends Intent {
    private final Collection<FlowRule> flowRules;
    private PathIntent.ProtectionType type;

    public FlowRuleIntent(ApplicationId appId, List<FlowRule> flowRules, Collection<NetworkResource> resources) {
        this(appId, null, flowRules, resources);
    }

    public FlowRuleIntent(ApplicationId appId, List<FlowRule> flowRules, Collection<NetworkResource> resources, PathIntent.ProtectionType type) {
        this(appId, null, flowRules, resources, type);
    }

    public FlowRuleIntent(ApplicationId appId, Key key, Collection<FlowRule> flowRules, Collection<NetworkResource> resources) {
        this(appId, key, flowRules, resources, PathIntent.ProtectionType.PRIMARY);
    }

    public FlowRuleIntent(ApplicationId appId, Key key, Collection<FlowRule> flowRules, Collection<NetworkResource> resources, PathIntent.ProtectionType primary) {
        super(appId, key, resources, 100);
        this.flowRules = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(flowRules)));
        this.type = primary;
    }

    public FlowRuleIntent(FlowRuleIntent intent, PathIntent.ProtectionType type) {
        this(intent.appId(), intent.key(), intent.flowRules(), intent.resources(), type);
    }

    protected FlowRuleIntent() {
        this.flowRules = null;
        this.type = PathIntent.ProtectionType.PRIMARY;
    }

    public Collection<FlowRule> flowRules() {
        return this.flowRules;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public PathIntent.ProtectionType type() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("resources", this.resources()).add("flowRule", this.flowRules).toString();
    }
}

