/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.OutboundPacket;

public final class DefaultOutboundPacket
implements OutboundPacket {
    private final DeviceId sendThrough;
    private final TrafficTreatment treatment;
    private final ByteBuffer data;

    public DefaultOutboundPacket(DeviceId sendThrough, TrafficTreatment treatment, ByteBuffer data) {
        this.sendThrough = sendThrough;
        this.treatment = treatment;
        this.data = data;
    }

    @Override
    public DeviceId sendThrough() {
        return this.sendThrough;
    }

    @Override
    public TrafficTreatment treatment() {
        return this.treatment;
    }

    @Override
    public ByteBuffer data() {
        return this.data;
    }

    public int hashCode() {
        return Objects.hash(this.sendThrough, this.treatment, this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OutboundPacket) {
            DefaultOutboundPacket other = (DefaultOutboundPacket)obj;
            return Objects.equals(this.sendThrough, other.sendThrough) && Objects.equals(this.treatment, other.treatment) && Objects.equals(this.data, other.data);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sendThrough", (Object)this.sendThrough).add("treatment", (Object)this.treatment).toString();
    }
}

