/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.region;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;

public final class DefaultRegion
implements Region {
    private final RegionId id;
    private final String name;
    private final Region.Type type;
    private final List<Set<NodeId>> masters;

    public DefaultRegion(RegionId id, String name, Region.Type type, List<Set<NodeId>> masters) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.masters = masters != null ? ImmutableList.copyOf(masters) : ImmutableList.of();
    }

    @Override
    public RegionId id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Region.Type type() {
        return this.type;
    }

    @Override
    public List<Set<NodeId>> masters() {
        return this.masters;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.masters});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRegion) {
            DefaultRegion that = (DefaultRegion)obj;
            return Objects.equals((Object)this.id, (Object)that.id) && Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.masters, that.masters);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("type", (Object)this.type).add("masters", this.masters).toString();
    }
}

