/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.MoreObjects;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiNode;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiTopology;

public class UiDevice
extends UiNode {
    private final UiTopology topology;
    private final Device device;
    private RegionId regionId;
    private NodeId masterId;

    public UiDevice(UiTopology topology, Device device) {
        this.topology = topology;
        this.device = device;
    }

    public void setRegionId(RegionId regionId) {
        this.regionId = regionId;
    }

    public void setMasterId(NodeId masterId) {
        this.masterId = masterId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("region", (Object)this.regionId).toString();
    }

    public DeviceId id() {
        return this.device.id();
    }

    @Override
    public String idAsString() {
        return this.id().toString();
    }

    public Device backingDevice() {
        return this.device;
    }

    public RegionId regionId() {
        return this.regionId;
    }

    public UiRegion uiRegion() {
        return this.topology.findRegion(this.regionId);
    }

    public String type() {
        return this.device.type().toString().toLowerCase();
    }

    public NodeId master() {
        return this.masterId;
    }
}

