/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.table.TableModel;
import org.onosproject.ui.table.TableUtils;

public abstract class TableRequestHandler
extends RequestHandler {
    private static final String FIRST_COL = "firstCol";
    private static final String FIRST_DIR = "firstDir";
    private static final String SECOND_COL = "secondCol";
    private static final String SECOND_DIR = "secondDir";
    private static final String ASC = "asc";
    private static final String ANNOTS = "annots";
    private static final String NO_ROWS_MSG_KEY = "no_rows_msg";
    private final String respType;
    private final String nodeName;

    public TableRequestHandler(String reqType, String respType, String nodeName) {
        super(reqType);
        this.respType = respType;
        this.nodeName = nodeName;
    }

    @Override
    public void process(long sid, ObjectNode payload) {
        TableModel tm = this.createTableModel();
        this.populateTable(tm, payload);
        String firstCol = JsonUtils.string(payload, FIRST_COL, this.defaultColumnId());
        String firstDir = JsonUtils.string(payload, FIRST_DIR, ASC);
        String secondCol = JsonUtils.string(payload, SECOND_COL, null);
        String secondDir = JsonUtils.string(payload, SECOND_DIR, null);
        tm.sort(firstCol, TableModel.sortDir(firstDir), secondCol, TableModel.sortDir(secondDir));
        this.addTableConfigAnnotations(tm, payload);
        ObjectNode rootNode = MAPPER.createObjectNode();
        rootNode.set(this.nodeName, (JsonNode)TableUtils.generateRowArrayNode(tm));
        rootNode.set(ANNOTS, (JsonNode)TableUtils.generateAnnotObjectNode(tm));
        this.sendMessage(this.respType, 0L, rootNode);
    }

    protected TableModel createTableModel() {
        return new TableModel(this.getColumnIds());
    }

    protected void addTableConfigAnnotations(TableModel tm, ObjectNode payload) {
        tm.addAnnotation(NO_ROWS_MSG_KEY, this.noRowsMessage(payload));
    }

    protected String defaultColumnId() {
        return "id";
    }

    protected abstract String[] getColumnIds();

    protected abstract String noRowsMessage(ObjectNode var1);

    protected abstract void populateTable(TableModel var1, ObjectNode var2);
}

