/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.cluster.Leader;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;

public class LeadershipTest {
    private final NodeId node1 = new NodeId("1");
    private final NodeId node2 = new NodeId("2");
    private final Leadership lead1 = new Leadership("topic1", new Leader(this.node1, 1L, 2L), Arrays.asList(this.node1));
    private final Leadership sameAsLead1 = new Leadership("topic1", new Leader(this.node1, 1L, 2L), Arrays.asList(this.node1));
    private final Leadership lead2 = new Leadership("topic2", new Leader(this.node1, 1L, 2L), Arrays.asList(this.node1));
    private final Leadership lead3 = new Leadership("topic1", new Leader(this.node1, 2L, 2L), Arrays.asList(this.node1));
    private final Leadership lead4 = new Leadership("topic1", new Leader(this.node1, 3L, 2L), Arrays.asList(this.node1));
    private final Leadership lead5 = new Leadership("topic1", new Leader(this.node1, 3L, 3L), Arrays.asList(this.node1));
    private final Leadership lead6 = new Leadership("topic1", new Leader(this.node2, 1L, 2L), Arrays.asList(this.node2, this.node1));
    private final Leadership lead7 = new Leadership("topic1", null, (List)ImmutableList.of());

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.lead1, this.sameAsLead1}).addEqualityGroup(new Object[]{this.lead2}).addEqualityGroup(new Object[]{this.lead3}).addEqualityGroup(new Object[]{this.lead4}).addEqualityGroup(new Object[]{this.lead5}).addEqualityGroup(new Object[]{this.lead6}).addEqualityGroup(new Object[]{this.lead7}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)this.lead6.leader(), (Matcher)Matchers.is((Object)new Leader(this.node2, 1L, 2L)));
        Assert.assertThat((Object)this.lead6.topic(), (Matcher)Matchers.is((Object)"topic1"));
        Assert.assertThat((Object)this.lead6.candidates(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(this.lead6.candidates().get(1), (Matcher)Matchers.is((Object)this.node1));
        Assert.assertThat(this.lead6.candidates().get(0), (Matcher)Matchers.is((Object)this.node2));
    }
}

