/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.MacAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.AbstractUiModelTest;
import org.onosproject.ui.model.topo.UiLinkId;

public class UiLinkIdTest
extends AbstractUiModelTest {
    private static final RegionId REG_1 = RegionId.regionId((String)"Region-1");
    private static final RegionId REG_2 = RegionId.regionId((String)"Region-2");
    private static final MacAddress MAC_A = MacAddress.valueOf((long)1193046L);
    private static final HostId HOST_A = HostId.hostId((MacAddress)MAC_A);
    private static final DeviceId DEV_X = DeviceId.deviceId((String)"device-X");
    private static final DeviceId DEV_Y = DeviceId.deviceId((String)"device-Y");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final PortNumber P3 = PortNumber.portNumber((long)3L);
    private static final ConnectPoint CP_X1 = new ConnectPoint((ElementId)DEV_X, P1);
    private static final ConnectPoint CP_Y2 = new ConnectPoint((ElementId)DEV_Y, P2);
    private static final ConnectPoint CP_Y3 = new ConnectPoint((ElementId)DEV_Y, P3);
    private static final ConnectPoint CP_HA = new ConnectPoint((ElementId)HOST_A, PortNumber.P0);
    private static final Link LINK_X1_TO_Y2 = DefaultLink.builder().providerId(ProviderId.NONE).src(CP_X1).dst(CP_Y2).type(Link.Type.DIRECT).build();
    private static final Link LINK_Y2_TO_X1 = DefaultLink.builder().providerId(ProviderId.NONE).src(CP_Y2).dst(CP_X1).type(Link.Type.DIRECT).build();
    private static final Link LINK_X1_TO_Y3 = DefaultLink.builder().providerId(ProviderId.NONE).src(CP_X1).dst(CP_Y3).type(Link.Type.DIRECT).build();
    private static final Link LINK_HA_TO_X1 = DefaultLink.builder().providerId(ProviderId.NONE).src(CP_HA).dst(CP_X1).type(Link.Type.EDGE).build();

    @Test
    public void canonical() {
        UiLinkIdTest.title("canonical");
        UiLinkId one = UiLinkId.uiLinkId((Link)LINK_X1_TO_Y2);
        UiLinkId two = UiLinkId.uiLinkId((Link)LINK_Y2_TO_X1);
        UiLinkIdTest.print("link one: %s", one);
        UiLinkIdTest.print("link two: %s", two);
        Assert.assertEquals((String)"not equiv", (Object)one, (Object)two);
    }

    @Test
    public void sameDevsDiffPorts() {
        UiLinkIdTest.title("sameDevsDiffPorts");
        UiLinkId one = UiLinkId.uiLinkId((Link)LINK_X1_TO_Y2);
        UiLinkId other = UiLinkId.uiLinkId((Link)LINK_X1_TO_Y3);
        UiLinkIdTest.print("link one: %s", one);
        UiLinkIdTest.print("link other: %s", other);
        Assert.assertNotEquals((String)"equiv?", (Object)one, (Object)other);
    }

    @Test
    public void edgeLink() {
        UiLinkIdTest.title("edgeLink");
        UiLinkId id = UiLinkId.uiLinkId((Link)LINK_HA_TO_X1);
        UiLinkIdTest.print("link: %s", id);
        Assert.assertEquals((String)"wrong port A", (Object)PortNumber.P0, (Object)id.portA());
        Assert.assertEquals((String)"wrong element A", (Object)HOST_A, (Object)id.elementA());
        Assert.assertEquals((String)"wrong port B", (Object)P1, (Object)id.portB());
        Assert.assertEquals((String)"wrong element B", (Object)DEV_X, (Object)id.elementB());
        Assert.assertNull((String)"region A?", (Object)id.regionA());
        Assert.assertNull((String)"region B?", (Object)id.regionB());
    }

    @Test
    public void deviceLink() {
        UiLinkIdTest.title("deviceLink");
        UiLinkId id = UiLinkId.uiLinkId((Link)LINK_X1_TO_Y2);
        UiLinkIdTest.print("link: %s", id);
        Assert.assertEquals((String)"wrong port A", (Object)P1, (Object)id.portA());
        Assert.assertEquals((String)"wrong element A", (Object)DEV_X, (Object)id.elementA());
        Assert.assertEquals((String)"wrong port B", (Object)P2, (Object)id.portB());
        Assert.assertEquals((String)"wrong element B", (Object)DEV_Y, (Object)id.elementB());
        Assert.assertNull((String)"region A?", (Object)id.regionA());
        Assert.assertNull((String)"region B?", (Object)id.regionB());
    }

    @Test
    public void regionLink() {
        UiLinkIdTest.title("regionLink");
        UiLinkId idFirst = UiLinkId.uiLinkId((RegionId)REG_1, (RegionId)REG_2);
        UiLinkId idSecond = UiLinkId.uiLinkId((RegionId)REG_2, (RegionId)REG_1);
        UiLinkIdTest.print(" first: %s", idFirst);
        UiLinkIdTest.print("second: %s", idSecond);
        Assert.assertEquals((String)"Not same ID", (Object)idFirst, (Object)idSecond);
    }

    @Test(expected=IllegalArgumentException.class)
    public void identicalRegionBad() {
        UiLinkId.uiLinkId((RegionId)REG_1, (RegionId)REG_1);
    }

    @Test(expected=NullPointerException.class)
    public void nullRegionBad() {
        UiLinkId.uiLinkId((RegionId)REG_1, (RegionId)null);
    }

    @Test
    public void regionDeviceLink() {
        UiLinkIdTest.title("regionDeviceLink");
        UiLinkId id = UiLinkId.uiLinkId((RegionId)REG_1, (DeviceId)DEV_X, (PortNumber)P1);
        UiLinkIdTest.print("id: %s", id);
        Assert.assertEquals((String)"region ID", (Object)REG_1, (Object)id.regionA());
        Assert.assertEquals((String)"device ID", (Object)DEV_X, (Object)id.elementB());
        Assert.assertEquals((String)"port", (Object)P1, (Object)id.portB());
    }
}

