/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.tuple.Pair;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerService;

@Beta
@NotThreadSafe
public class ListenerTracker {
    private List<Pair<ListenerService, EventListener>> listeners = new ArrayList<Pair<ListenerService, EventListener>>();

    public <E extends Event<?, ?>, L extends EventListener<E>> ListenerTracker addListener(ListenerService<E, L> service, L listener) {
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(listener);
        service.addListener(listener);
        this.listeners.add((Pair<ListenerService, EventListener>)Pair.of(service, listener));
        return this;
    }

    public void removeListeners() {
        Lists.reverse(this.listeners).forEach(r -> ((ListenerService)r.getLeft()).removeListener((EventListener)r.getRight()));
        this.listeners.clear();
    }
}

