/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.link.LinkDescription;

public final class LinkKey {
    private final ConnectPoint src;
    private final ConnectPoint dst;

    public ConnectPoint src() {
        return this.src;
    }

    public ConnectPoint dst() {
        return this.dst;
    }

    private LinkKey(ConnectPoint src, ConnectPoint dst) {
        this.src = (ConnectPoint)Preconditions.checkNotNull((Object)src);
        this.dst = (ConnectPoint)Preconditions.checkNotNull((Object)dst);
    }

    public static LinkKey linkKey(ConnectPoint src, ConnectPoint dst) {
        return new LinkKey(src, dst);
    }

    public static LinkKey linkKey(Link link) {
        return new LinkKey(link.src(), link.dst());
    }

    public static LinkKey linkKey(LinkDescription link) {
        return new LinkKey(link.src(), link.dst());
    }

    public int hashCode() {
        return Objects.hash(this.src, this.dst);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkKey) {
            LinkKey other = (LinkKey)obj;
            return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("src", (Object)this.src).add("dst", (Object)this.dst).toString();
    }
}

