/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.io.IOException;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.net.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfig<S>
extends Config<S>
implements CodecContext {
    private static final ServiceDirectory SERVICES = new DefaultServiceDirectory();
    private static final Logger log = LoggerFactory.getLogger(BaseConfig.class);

    @Override
    public <T> JsonCodec<T> codec(Class<T> entityClass) {
        return this.getService(CodecService.class).getCodec(entityClass);
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        return (T)SERVICES.get(serviceClass);
    }

    @Override
    public ObjectMapper mapper() {
        return this.mapper;
    }

    protected <T> T decode(String json, Class<T> entityClass) {
        try {
            return this.decode(this.mapper().readTree(json), entityClass);
        }
        catch (IOException e) {
            log.error("Exception caught.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

