/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Link;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;

@Beta
public abstract class ConnectivityIntent
extends Intent {
    private final TrafficSelector selector;
    private final TrafficTreatment treatment;
    private final List<Constraint> constraints;

    protected ConnectivityIntent(ApplicationId appId, Key key, Collection<NetworkResource> resources, TrafficSelector selector, TrafficTreatment treatment, List<Constraint> constraints, int priority) {
        super(appId, key, resources, priority);
        this.selector = (TrafficSelector)Preconditions.checkNotNull((Object)selector);
        this.treatment = (TrafficTreatment)Preconditions.checkNotNull((Object)treatment);
        this.constraints = (List)Preconditions.checkNotNull(constraints);
    }

    protected ConnectivityIntent() {
        this.selector = null;
        this.treatment = null;
        this.constraints = Collections.emptyList();
    }

    public TrafficSelector selector() {
        return this.selector;
    }

    public TrafficTreatment treatment() {
        return this.treatment;
    }

    public List<Constraint> constraints() {
        return this.constraints;
    }

    protected static Collection<NetworkResource> resources(Collection<Link> links) {
        return ImmutableSet.copyOf(links);
    }

    public static abstract class Builder
    extends Intent.Builder {
        protected TrafficSelector selector = DefaultTrafficSelector.emptySelector();
        protected TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        protected List<Constraint> constraints = ImmutableList.of();

        protected Builder() {
        }

        protected Builder(ConnectivityIntent intent) {
            super(intent);
            this.selector(intent.selector()).treatment(intent.treatment()).constraints(intent.constraints());
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder selector(TrafficSelector selector) {
            this.selector = selector;
            return this;
        }

        public Builder treatment(TrafficTreatment treatment) {
            this.treatment = treatment;
            return this;
        }

        public Builder constraints(List<Constraint> constraints) {
            this.constraints = ImmutableList.copyOf(constraints);
            return this;
        }
    }
}

