/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class LinkCollectionIntent
extends ConnectivityIntent {
    private final Set<Link> links;
    private final Set<FilteredConnectPoint> ingressPoints;
    private final Set<FilteredConnectPoint> egressPoints;
    private final boolean egressTreatmentFlag;
    private final double cost;
    private static final int DEFAULT_COST = 1;

    private LinkCollectionIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Set<Link> links, Set<FilteredConnectPoint> ingressPoints, Set<FilteredConnectPoint> egressPoints, List<Constraint> constraints, int priority, boolean egressTreatment, double cost) {
        super(appId, key, LinkCollectionIntent.resources(links), selector, treatment, constraints, priority);
        this.links = links;
        this.ingressPoints = ingressPoints;
        this.egressPoints = egressPoints;
        this.egressTreatmentFlag = egressTreatment;
        this.cost = cost;
    }

    private LinkCollectionIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Set<Link> links, Set<FilteredConnectPoint> ingressPoints, Set<FilteredConnectPoint> egressPoints, List<Constraint> constraints, int priority, boolean egressTreatment) {
        this(appId, key, selector, treatment, links, ingressPoints, egressPoints, constraints, priority, egressTreatment, 1.0);
    }

    protected LinkCollectionIntent() {
        this.links = null;
        this.ingressPoints = null;
        this.egressPoints = null;
        this.egressTreatmentFlag = false;
        this.cost = 1.0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<Link> links() {
        return this.links;
    }

    public Set<ConnectPoint> ingressPoints() {
        if (this.ingressPoints == null) {
            return null;
        }
        return this.ingressPoints.stream().map(FilteredConnectPoint::connectPoint).collect(Collectors.toSet());
    }

    public Set<ConnectPoint> egressPoints() {
        if (this.egressPoints == null) {
            return null;
        }
        return this.egressPoints.stream().map(FilteredConnectPoint::connectPoint).collect(Collectors.toSet());
    }

    public Set<FilteredConnectPoint> filteredIngressPoints() {
        return this.ingressPoints;
    }

    public Set<FilteredConnectPoint> filteredEgressPoints() {
        return this.egressPoints;
    }

    public boolean applyTreatmentOnEgress() {
        return this.egressTreatmentFlag;
    }

    public double cost() {
        return this.cost;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("links", this.links()).add("ingress", this.ingressPoints()).add("egress", this.egressPoints()).add("treatementOnEgress", this.applyTreatmentOnEgress()).add("cost", this.cost()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private Set<Link> links;
        private Set<FilteredConnectPoint> ingressPoints;
        private Set<FilteredConnectPoint> egressPoints;
        private boolean egressTreatmentFlag;
        private double cost;

        private Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Deprecated
        public Builder ingressPoints(Set<ConnectPoint> ingressPoints) {
            if (this.ingressPoints != null) {
                this.log.warn("Ingress points are already set, this will override original ingress points.");
            }
            this.ingressPoints = ingressPoints.stream().map(FilteredConnectPoint::new).collect(Collectors.toSet());
            return this;
        }

        @Deprecated
        public Builder egressPoints(Set<ConnectPoint> egressPoints) {
            if (this.egressPoints != null) {
                this.log.warn("Egress points are already set, this will override original egress points.");
            }
            this.egressPoints = egressPoints.stream().map(FilteredConnectPoint::new).collect(Collectors.toSet());
            return this;
        }

        public Builder filteredIngressPoints(Set<FilteredConnectPoint> ingressPoints) {
            this.ingressPoints = ImmutableSet.copyOf(ingressPoints);
            return this;
        }

        public Builder filteredEgressPoints(Set<FilteredConnectPoint> egressPoints) {
            this.egressPoints = ImmutableSet.copyOf(egressPoints);
            return this;
        }

        public Builder links(Set<Link> links) {
            this.links = ImmutableSet.copyOf(links);
            return this;
        }

        public Builder applyTreatmentOnEgress(boolean treatmentOnEgress) {
            this.egressTreatmentFlag = treatmentOnEgress;
            return this;
        }

        public Builder cost(double cost) {
            this.cost = cost;
            return this;
        }

        public LinkCollectionIntent build() {
            return new LinkCollectionIntent(this.appId, this.key, this.selector, this.treatment, this.links, this.ingressPoints, this.egressPoints, this.constraints, this.priority, this.egressTreatmentFlag, this.cost);
        }
    }
}

