/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.Throwables;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.ConsistentMultimap;
import org.onosproject.store.service.Synchronous;
import org.onosproject.store.service.Versioned;

public class DefaultConsistentMultimap<K, V>
extends Synchronous<AsyncConsistentMultimap<K, V>>
implements ConsistentMultimap<K, V> {
    private final AsyncConsistentMultimap<K, V> asyncMultimap;
    private final long operationTimeoutMillis;

    public DefaultConsistentMultimap(AsyncConsistentMultimap<K, V> asyncMultimap, long operationTimeoutMillis) {
        super(asyncMultimap);
        this.asyncMultimap = asyncMultimap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int size() {
        return this.complete(this.asyncMultimap.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncMultimap.isEmpty());
    }

    @Override
    public boolean containsKey(K key) {
        return this.complete(this.asyncMultimap.containsKey(key));
    }

    @Override
    public boolean containsValue(V value) {
        return this.complete(this.asyncMultimap.containsValue(value));
    }

    @Override
    public boolean containsEntry(K key, V value) {
        return this.complete(this.asyncMultimap.containsEntry(key, value));
    }

    @Override
    public boolean put(K key, V value) {
        return this.complete(this.asyncMultimap.put(key, value));
    }

    @Override
    public boolean remove(K key, V value) {
        return this.complete(this.asyncMultimap.remove(key, value));
    }

    @Override
    public boolean removeAll(K key, Collection<? extends V> values) {
        return this.complete(this.asyncMultimap.removeAll(key, values));
    }

    @Override
    public Versioned<Collection<? extends V>> removeAll(K key) {
        return this.complete(this.asyncMultimap.removeAll(key));
    }

    @Override
    public boolean putAll(K key, Collection<? extends V> values) {
        return this.complete(this.asyncMultimap.putAll(key, values));
    }

    @Override
    public Versioned<Collection<? extends V>> replaceValues(K key, Collection<V> values) {
        return this.complete(this.asyncMultimap.replaceValues(key, values));
    }

    @Override
    public void clear() {
        this.complete(this.asyncMultimap.clear());
    }

    @Override
    public Versioned<Collection<? extends V>> get(K key) {
        return this.complete(this.asyncMultimap.get(key));
    }

    @Override
    public Set<K> keySet() {
        return this.complete(this.asyncMultimap.keySet());
    }

    @Override
    public Multiset<K> keys() {
        return this.complete(this.asyncMultimap.keys());
    }

    @Override
    public Multiset<V> values() {
        return this.complete(this.asyncMultimap.values());
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return this.complete(this.asyncMultimap.entries());
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsistentMapException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new ConsistentMapException.Timeout();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new ConsistentMapException(e.getCause());
        }
    }
}

