/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.Throwables;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.onosproject.store.primitives.ConsistentMapBackedJavaMap;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.ConsistentTreeMap;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Synchronous;
import org.onosproject.store.service.Versioned;

public class DefaultConsistentTreeMap<V>
extends Synchronous<AsyncConsistentTreeMap<V>>
implements ConsistentTreeMap<V> {
    private final AsyncConsistentTreeMap<V> treeMap;
    private final long operationTimeoutMillis;
    private Map<String, V> javaMap;

    public DefaultConsistentTreeMap(AsyncConsistentTreeMap<V> treeMap, long operationTimeoutMillis) {
        super(treeMap);
        this.treeMap = treeMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsistentMapException.Interrupted();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new ConsistentMapException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new ConsistentMapException.Timeout();
        }
    }

    @Override
    public String firstKey() {
        return this.complete(this.treeMap.firstKey());
    }

    @Override
    public String lastKey() {
        return this.complete(this.treeMap.lastKey());
    }

    @Override
    public Map.Entry<String, Versioned<V>> ceilingEntry(String key) {
        return this.complete(this.treeMap.ceilingEntry(key));
    }

    @Override
    public Map.Entry<String, Versioned<V>> floorEntry(String key) {
        return this.complete(this.treeMap.floorEntry(key));
    }

    @Override
    public Map.Entry<String, Versioned<V>> higherEntry(String key) {
        return this.complete(this.treeMap.higherEntry(key));
    }

    @Override
    public Map.Entry<String, Versioned<V>> lowerEntry(String key) {
        return this.complete(this.treeMap.lowerEntry(key));
    }

    @Override
    public Map.Entry<String, Versioned<V>> firstEntry() {
        return this.complete(this.treeMap.firstEntry());
    }

    @Override
    public Map.Entry<String, Versioned<V>> lastEntry() {
        return this.complete(this.treeMap.lastEntry());
    }

    @Override
    public Map.Entry<String, Versioned<V>> pollFirstEntry() {
        return this.complete(this.treeMap.pollFirstEntry());
    }

    @Override
    public Map.Entry<String, Versioned<V>> pollLastEntry() {
        return this.complete(this.treeMap.pollLastEntry());
    }

    @Override
    public String lowerKey(String key) {
        return this.complete(this.treeMap.lowerKey(key));
    }

    @Override
    public String floorKey(String key) {
        return this.complete(this.treeMap.floorKey(key));
    }

    @Override
    public String ceilingKey(String key) {
        return this.complete(this.treeMap.ceilingKey(key));
    }

    @Override
    public String higherKey(String key) {
        return this.complete(this.treeMap.higherKey(key));
    }

    @Override
    public NavigableSet<String> navigableKeySet() {
        return this.complete(this.treeMap.navigableKeySet());
    }

    @Override
    public int size() {
        return this.complete(this.treeMap.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.treeMap.isEmpty());
    }

    @Override
    public boolean containsKey(String key) {
        return this.complete(this.treeMap.containsKey(key));
    }

    @Override
    public boolean containsValue(V value) {
        return this.complete(this.treeMap.containsValue(value));
    }

    @Override
    public Versioned<V> get(String key) {
        return this.complete(this.treeMap.get(key));
    }

    @Override
    public Versioned<V> getOrDefault(String key, V defaultValue) {
        return this.complete(this.treeMap.getOrDefault(key, defaultValue));
    }

    @Override
    public Versioned<V> computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
        return this.complete(this.treeMap.computeIfAbsent(key, mappingFunction));
    }

    @Override
    public Versioned<V> compute(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return this.complete(this.treeMap.compute(key, remappingFunction));
    }

    @Override
    public Versioned<V> computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return this.complete(this.treeMap.computeIfPresent(key, remappingFunction));
    }

    @Override
    public Versioned<V> computeIf(String key, Predicate<? super V> condition, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return this.complete(this.treeMap.computeIf(key, condition, remappingFunction));
    }

    @Override
    public Versioned<V> put(String key, V value) {
        return this.complete(this.treeMap.put(key, value));
    }

    @Override
    public Versioned<V> putAndGet(String key, V value) {
        return this.complete(this.treeMap.putAndGet(key, value));
    }

    @Override
    public Versioned<V> remove(String key) {
        return this.complete(this.treeMap.remove(key));
    }

    @Override
    public void clear() {
        this.complete(this.treeMap.clear());
    }

    @Override
    public Set<String> keySet() {
        return this.complete(this.treeMap.keySet());
    }

    @Override
    public Collection<Versioned<V>> values() {
        return this.complete(this.treeMap.values());
    }

    @Override
    public Set<Map.Entry<String, Versioned<V>>> entrySet() {
        return this.complete(this.treeMap.entrySet());
    }

    @Override
    public Versioned<V> putIfAbsent(String key, V value) {
        return this.complete(this.treeMap.putIfAbsent(key, value));
    }

    @Override
    public boolean remove(String key, V value) {
        return this.complete(this.treeMap.remove(key, value));
    }

    @Override
    public boolean remove(String key, long version) {
        return this.complete(this.treeMap.remove(key, version));
    }

    @Override
    public Versioned<V> replace(String key, V value) {
        return this.complete(this.treeMap.replace(key, value));
    }

    @Override
    public boolean replace(String key, V oldValue, V newValue) {
        return this.complete(this.treeMap.replace(key, oldValue, newValue));
    }

    @Override
    public boolean replace(String key, long oldVersion, V newValue) {
        return this.complete(this.treeMap.replace(key, oldVersion, newValue));
    }

    @Override
    public void addListener(MapEventListener<String, V> listener, Executor executor) {
        this.complete(this.treeMap.addListener(listener, executor));
    }

    @Override
    public void removeListener(MapEventListener<String, V> listener) {
        this.complete(this.treeMap.removeListener(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, V> asJavaMap() {
        DefaultConsistentTreeMap defaultConsistentTreeMap = this;
        synchronized (defaultConsistentTreeMap) {
            if (this.javaMap == null) {
                this.javaMap = new ConsistentMapBackedJavaMap<String, V>(this);
            }
        }
        return this.javaMap;
    }

    @Override
    public NavigableMap<String, V> subMap(String upperKey, String lowerKey, boolean inclusiveUpper, boolean inclusiveLower) {
        return this.complete(this.treeMap.subMap(upperKey, lowerKey, inclusiveUpper, inclusiveLower));
    }
}

