/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.DefaultConsistentMultimap;
import org.onosproject.store.service.ConsistentMultimap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Versioned;

public interface AsyncConsistentMultimap<K, V>
extends DistributedPrimitive {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.CONSISTENT_MULTIMAP;
    }

    @Override
    default public CompletableFuture<Void> destroy() {
        return this.clear();
    }

    public CompletableFuture<Integer> size();

    public CompletableFuture<Boolean> isEmpty();

    public CompletableFuture<Boolean> containsKey(K var1);

    public CompletableFuture<Boolean> containsValue(V var1);

    public CompletableFuture<Boolean> containsEntry(K var1, V var2);

    public CompletableFuture<Boolean> put(K var1, V var2);

    public CompletableFuture<Boolean> remove(K var1, V var2);

    public CompletableFuture<Boolean> removeAll(K var1, Collection<? extends V> var2);

    public CompletableFuture<Versioned<Collection<? extends V>>> removeAll(K var1);

    public CompletableFuture<Boolean> putAll(K var1, Collection<? extends V> var2);

    public CompletableFuture<Versioned<Collection<? extends V>>> replaceValues(K var1, Collection<V> var2);

    public CompletableFuture<Void> clear();

    public CompletableFuture<Versioned<Collection<? extends V>>> get(K var1);

    public CompletableFuture<Set<K>> keySet();

    public CompletableFuture<Multiset<K>> keys();

    public CompletableFuture<Multiset<V>> values();

    public CompletableFuture<Collection<Map.Entry<K, V>>> entries();

    public CompletableFuture<Map<K, Collection<V>>> asMap();

    default public ConsistentMultimap<K, V> asMultimap() {
        return this.asMultimap(5000L);
    }

    default public ConsistentMultimap<K, V> asMultimap(long timeoutMillis) {
        return new DefaultConsistentMultimap(this, timeoutMillis);
    }
}

