/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Objects;
import org.onosproject.store.Timestamp;

public class Version
implements Timestamp {
    private final long version;

    public Version(long version) {
        this.version = version;
    }

    @Override
    public int compareTo(Timestamp o) {
        Preconditions.checkArgument((boolean)(o instanceof Version), (String)"Must be LockVersion", (Object[])new Object[]{o});
        Version that = (Version)o;
        return ComparisonChain.start().compare(this.version, that.version).result();
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.version);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version that = (Version)obj;
        return Objects.equals(this.version, that.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("version", this.version).toString();
    }

    public long value() {
        return this.version;
    }
}

