/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.UiMessageHandler;

public abstract class RequestHandler {
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    private final String eventType;
    private UiMessageHandler parent;

    public RequestHandler(String eventType) {
        this.eventType = eventType;
    }

    void setParent(UiMessageHandler parent) {
        this.parent = parent;
    }

    public String eventType() {
        return this.eventType;
    }

    public abstract void process(long var1, ObjectNode var3);

    protected <T> T get(Class<T> serviceClass) {
        return (T)this.parent.directory().get(serviceClass);
    }

    @Deprecated
    protected void sendMessage(String eventType, long sid, ObjectNode payload) {
        this.parent.connection().sendMessage(eventType, sid, payload);
    }

    protected void sendMessage(String eventType, ObjectNode payload) {
        this.parent.connection().sendMessage(eventType, 0L, payload);
    }

    protected void sendMessage(ObjectNode message) {
        this.parent.connection().sendMessage(message);
    }

    protected void chain(String eventType, long sid, ObjectNode payload) {
        this.parent.exec(eventType, sid, payload);
    }

    protected String string(ObjectNode node, String key) {
        return JsonUtils.string(node, key);
    }

    protected String string(ObjectNode node, String key, String defValue) {
        return JsonUtils.string(node, key, defValue);
    }

    protected boolean bool(ObjectNode node, String key) {
        return JsonUtils.bool(node, key);
    }
}

