/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.DeviceId;
import org.onosproject.ui.model.topo.UiElement;
import org.onosproject.ui.model.topo.UiTopology;

public class UiClusterMember
extends UiElement {
    private final UiTopology topology;
    private final ControllerNode cnode;
    private ControllerNode.State state = ControllerNode.State.INACTIVE;
    private final Set<DeviceId> mastership = new HashSet<DeviceId>();

    public UiClusterMember(UiTopology topology, ControllerNode cnode) {
        this.topology = topology;
        this.cnode = cnode;
    }

    public String toString() {
        return "UiClusterMember{" + this.cnode + ", online=" + this.isOnline() + ", ready=" + this.isReady() + ", #devices=" + this.deviceCount() + "}";
    }

    @Override
    public String idAsString() {
        return this.id().toString();
    }

    public ControllerNode backingNode() {
        return this.cnode;
    }

    public void setState(ControllerNode.State state) {
        this.state = state;
    }

    public void setMastership(Set<DeviceId> mastership) {
        this.mastership.clear();
        this.mastership.addAll(mastership);
    }

    public NodeId id() {
        return this.cnode.id();
    }

    public IpAddress ip() {
        return this.cnode.ip();
    }

    public boolean isOnline() {
        return this.state.isActive();
    }

    public boolean isReady() {
        return this.state.isReady();
    }

    public int deviceCount() {
        return this.mastership.size();
    }

    public Set<DeviceId> masterOf() {
        return Collections.unmodifiableSet(this.mastership);
    }

    public boolean masterOf(DeviceId deviceId) {
        return this.mastership.contains(deviceId);
    }
}

