/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiTopology;

public class UiDeviceLink
extends UiLink {
    private static final String E_UNASSOC = "backing link not associated with this UI device link: ";
    private DeviceId deviceA;
    private DeviceId deviceB;
    private PortNumber portA;
    private PortNumber portB;
    private Link linkAtoB;
    private Link linkBtoA;

    public UiDeviceLink(UiTopology topology, UiLinkId id) {
        super(topology, id);
    }

    @Override
    public String endPointA() {
        return this.deviceA + "/" + this.portA;
    }

    @Override
    public String endPointB() {
        return this.deviceB + "/" + this.portB;
    }

    @Override
    public String endPortA() {
        return this.portA.toString();
    }

    @Override
    public String endPortB() {
        return this.portB.toString();
    }

    @Override
    protected void destroy() {
        this.deviceA = null;
        this.deviceB = null;
        this.portA = null;
        this.portB = null;
        this.linkAtoB = null;
        this.linkBtoA = null;
    }

    public void attachBackingLink(Link link) {
        UiLinkId.Direction d = this.id.directionOf(link);
        if (d == UiLinkId.Direction.A_TO_B) {
            this.linkAtoB = link;
            this.deviceA = link.src().deviceId();
            this.portA = link.src().port();
            this.deviceB = link.dst().deviceId();
            this.portB = link.dst().port();
        } else if (d == UiLinkId.Direction.B_TO_A) {
            this.linkBtoA = link;
            this.deviceB = link.src().deviceId();
            this.portB = link.src().port();
            this.deviceA = link.dst().deviceId();
            this.portA = link.dst().port();
        } else {
            throw new IllegalArgumentException(E_UNASSOC + link);
        }
    }

    public boolean detachBackingLink(Link link) {
        UiLinkId.Direction d = this.id.directionOf(link);
        if (d == UiLinkId.Direction.A_TO_B) {
            this.linkAtoB = null;
            return this.linkBtoA != null;
        }
        if (d == UiLinkId.Direction.B_TO_A) {
            this.linkBtoA = null;
            return this.linkAtoB != null;
        }
        throw new IllegalArgumentException(E_UNASSOC + link);
    }

    public DeviceId deviceA() {
        return this.deviceA;
    }

    public PortNumber portA() {
        return this.portA;
    }

    public DeviceId deviceB() {
        return this.deviceB;
    }

    public PortNumber portB() {
        return this.portB;
    }

    public Link linkAtoB() {
        return this.linkAtoB;
    }

    public Link linkBtoA() {
        return this.linkBtoA;
    }
}

