/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.InvalidFieldException;
import org.onosproject.net.config.basics.AbstractConfigTest;
import org.onosproject.net.config.basics.BasicRegionConfig;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;

public class BasicRegionConfigTest
extends AbstractConfigTest {
    private static final String REGION_JSON = "configs.regions.1.json";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String DEVICES = "devices";
    private static final String R1 = "r1";
    private static final String R2 = "r2";
    private static final String R3 = "r3";
    private static final String EUROPE = "Europe";
    private static final String PARIS = "Paris";
    private static final String AUSTRALIA = "Australia";
    private static final Set<DeviceId> R1_DEVS = ImmutableSet.of((Object)BasicRegionConfigTest.dstr("01"), (Object)BasicRegionConfigTest.dstr("02"), (Object)BasicRegionConfigTest.dstr("03"));
    private static final Set<DeviceId> R2_DEVS = ImmutableSet.of((Object)BasicRegionConfigTest.dstr("04"), (Object)BasicRegionConfigTest.dstr("05"), (Object)BasicRegionConfigTest.dstr("06"));
    private static final Set<DeviceId> R3_DEVS = ImmutableSet.of((Object)BasicRegionConfigTest.dstr("07"), (Object)BasicRegionConfigTest.dstr("08"), (Object)BasicRegionConfigTest.dstr("09"));
    private static final Set<DeviceId> ALT_DEVICES = ImmutableSet.of((Object)BasicRegionConfigTest.dstr("0a"), (Object)BasicRegionConfigTest.dstr("0b"), (Object)BasicRegionConfigTest.dstr("0c"));
    private JsonNode data;
    private BasicRegionConfig cfg;

    @Before
    public void setUp() {
        this.data = this.getTestJson(REGION_JSON);
    }

    private JsonNode getR(String key) {
        return this.data.get("regions").get(key).get("basic");
    }

    private void loadRegion(String rid) {
        JsonNode node = this.getR(rid);
        BasicRegionConfigTest.print("%nJSON loaded: %s", node);
        this.cfg = new BasicRegionConfig();
        this.cfg.init((Object)RegionId.regionId((String)rid), rid, node, this.mapper, this.delegate);
    }

    private void checkRegion(String expN, Region.Type expT, Set<DeviceId> expD) {
        BasicRegionConfigTest.print("   checking: %s", this.cfg);
        Assert.assertEquals((String)"wrong name", (Object)expN, (Object)this.cfg.name());
        Assert.assertEquals((String)"wrong type", (Object)expT, (Object)this.cfg.type());
        List devs = this.cfg.devices();
        if (expD == null) {
            Assert.assertNull((String)"unexp device list", (Object)devs);
        } else {
            Assert.assertNotNull((Object)devs);
            Assert.assertEquals((String)"wr.size", (long)expD.size(), (long)devs.size());
            for (DeviceId d : expD) {
                Assert.assertTrue((String)("missing dev: " + d), (boolean)devs.contains(d));
            }
        }
    }

    @Test
    public void region1Config() {
        this.loadRegion(R1);
        this.checkRegion(EUROPE, Region.Type.CONTINENT, R1_DEVS);
    }

    @Test
    public void region2Config() {
        this.loadRegion(R2);
        this.checkRegion(PARIS, Region.Type.METRO, R2_DEVS);
    }

    @Test
    public void region3Config() {
        this.loadRegion(R3);
        this.checkRegion(null, null, R3_DEVS);
    }

    @Test
    public void modifyName() {
        this.loadRegion(R1);
        this.cfg.name(AUSTRALIA);
        this.checkRegion(AUSTRALIA, Region.Type.CONTINENT, R1_DEVS);
    }

    @Test
    public void clearName() {
        this.loadRegion(R1);
        this.cfg.name(null);
        this.checkRegion(null, Region.Type.CONTINENT, R1_DEVS);
    }

    @Test
    public void modifyType() {
        this.loadRegion(R2);
        this.cfg.type(Region.Type.CAMPUS);
        this.checkRegion(PARIS, Region.Type.CAMPUS, R2_DEVS);
    }

    @Test
    public void clearType() {
        this.loadRegion(R2);
        this.cfg.type(null);
        this.checkRegion(PARIS, null, R2_DEVS);
    }

    @Test
    public void modifyDevices() {
        this.loadRegion(R3);
        this.cfg.devices(ALT_DEVICES);
        this.checkRegion(null, null, ALT_DEVICES);
    }

    @Test
    public void clearDevices() {
        this.loadRegion(R3);
        this.cfg.devices(null);
        this.checkRegion(null, null, null);
    }

    @Test
    public void sampleValidConfig() {
        ObjectNode node = new AbstractConfigTest.TmpJson().props(NAME, TYPE).arrays(DEVICES).node();
        this.cfg = new BasicRegionConfig();
        this.cfg.init((Object)RegionId.regionId((String)R1), "basic", (JsonNode)node, this.mapper, this.delegate);
        Assert.assertTrue((String)("not valid: " + this.cfg), (boolean)this.cfg.isValid());
    }

    @Test(expected=InvalidFieldException.class)
    public void sampleInvalidConfig() {
        ObjectNode node = new AbstractConfigTest.TmpJson().props(NAME, TYPE, "foo").arrays(DEVICES).node();
        this.cfg = new BasicRegionConfig();
        this.cfg.init((Object)RegionId.regionId((String)R1), "basic", (JsonNode)node, this.mapper, this.delegate);
        this.cfg.isValid();
    }
}

