/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.region.DefaultRegion;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

public class UiTopoLayoutTest {
    private static final String AM_NOEX = "no exception thrown";
    private static final String AM_WREXMSG = "wrong exception message";
    private static final double DELTA = 9.9E-324;
    private static final UiTopoLayoutId OTHER_ID = UiTopoLayoutId.layoutId((String)"other-id");
    private static final RegionId REGION_ID = RegionId.regionId((String)"some-region");
    private static final Region REGION = new DefaultRegion(REGION_ID, "Region-1", Region.Type.CAMPUS, null);
    private static final String GEOMAP = "geo1";
    private static final String SPRITE = "spr1";
    private UiTopoLayout layout;

    private void mkRootLayout() {
        this.layout = new UiTopoLayout(UiTopoLayoutId.DEFAULT_ID);
    }

    private void mkOtherLayout() {
        this.layout = new UiTopoLayout(OTHER_ID);
    }

    @Test(expected=NullPointerException.class)
    public void nullIdentifier() {
        this.layout = new UiTopoLayout(null);
    }

    @Test
    public void rootLayout() {
        this.mkRootLayout();
        Assert.assertEquals((String)"wrong id", (Object)UiTopoLayoutId.DEFAULT_ID, (Object)this.layout.id());
        Assert.assertEquals((String)"wrong parent (not self)", (Object)UiTopoLayoutId.DEFAULT_ID, (Object)this.layout.parent());
        Assert.assertTrue((String)"should be root", (boolean)this.layout.isRoot());
        Assert.assertNull((String)"unexpected region", (Object)this.layout.region());
        Assert.assertEquals((String)"unexpected region id", (Object)UiRegion.NULL_ID, (Object)this.layout.regionId());
    }

    @Test
    public void otherLayout() {
        this.mkOtherLayout();
        Assert.assertEquals((String)"wrong id", (Object)OTHER_ID, (Object)this.layout.id());
        Assert.assertEquals((String)"not null parent", null, (Object)this.layout.parent());
        Assert.assertFalse((String)"should NOT be root", (boolean)this.layout.isRoot());
        Assert.assertNull((String)"unexpected region", (Object)this.layout.region());
        Assert.assertNull((String)"unexpected region id", (Object)this.layout.regionId());
        Assert.assertNull((String)"unexpected geomap", (Object)this.layout.geomap());
        Assert.assertNull((String)"unexpected sprites", (Object)this.layout.sprites());
        Assert.assertEquals((String)"non-unity scale", (double)1.0, (double)this.layout.scale(), (double)9.9E-324);
        Assert.assertEquals((String)"non-zero x-off", (double)0.0, (double)this.layout.offsetX(), (double)9.9E-324);
        Assert.assertEquals((String)"non-zero y-off", (double)0.0, (double)this.layout.offsetY(), (double)9.9E-324);
    }

    @Test
    public void setRegionOnRoot() {
        this.mkRootLayout();
        try {
            this.layout.region(REGION);
            Assert.fail((String)AM_NOEX);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)AM_WREXMSG, (Object)"Cannot set region on root layout", (Object)e.getMessage());
        }
        try {
            this.layout.region(null);
            Assert.fail((String)AM_NOEX);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)AM_WREXMSG, (Object)"Cannot set region on root layout", (Object)e.getMessage());
        }
    }

    @Test
    public void setRegionOnOther() {
        this.mkOtherLayout();
        this.layout.region(REGION);
        Assert.assertEquals((String)"wrong region", (Object)REGION, (Object)this.layout.region());
        Assert.assertEquals((String)"wrong region id", (Object)REGION_ID, (Object)this.layout.regionId());
        this.layout.region(null);
        Assert.assertEquals((String)"non-null region", null, (Object)this.layout.region());
        Assert.assertEquals((String)"non-null region id", null, (Object)this.layout.regionId());
    }

    @Test
    public void setParentOnRoot() {
        this.mkRootLayout();
        try {
            this.layout.parent(OTHER_ID);
            Assert.fail((String)AM_NOEX);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)AM_WREXMSG, (Object)"Cannot change parent ID of root layout", (Object)e.getMessage());
        }
        try {
            this.layout.parent(null);
            Assert.fail((String)AM_NOEX);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)AM_WREXMSG, (Object)"Cannot change parent ID of root layout", (Object)e.getMessage());
        }
    }

    @Test
    public void setParentOnOther() {
        this.mkOtherLayout();
        this.layout.parent(OTHER_ID);
        Assert.assertEquals((String)"wrong parent", (Object)OTHER_ID, (Object)this.layout.parent());
        this.layout.parent(null);
        Assert.assertEquals((String)"non-null parent", null, (Object)this.layout.parent());
    }

    @Test
    public void setGeomap() {
        this.mkRootLayout();
        Assert.assertEquals((String)"geo to start", null, (Object)this.layout.geomap());
        this.layout.geomap(GEOMAP);
        Assert.assertEquals((String)"wrong geo", (Object)GEOMAP, (Object)this.layout.geomap());
    }

    @Test
    public void setGeomapAfterSprites() {
        this.mkRootLayout();
        this.layout.sprites(SPRITE);
        Assert.assertEquals((String)"geo to start", null, (Object)this.layout.geomap());
        try {
            this.layout.geomap(GEOMAP);
            Assert.fail((String)AM_NOEX);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)AM_WREXMSG, (Object)"Cannot set geomap if sprites is set", (Object)e.getMessage());
        }
    }

    @Test
    public void setSprites() {
        this.mkRootLayout();
        Assert.assertEquals((String)"sprite to start", null, (Object)this.layout.sprites());
        this.layout.sprites(SPRITE);
        Assert.assertEquals((String)"wrong sprite", (Object)SPRITE, (Object)this.layout.sprites());
    }

    @Test
    public void setSpritesAfterGeomap() {
        this.mkRootLayout();
        this.layout.geomap(GEOMAP);
        Assert.assertEquals((String)"sprites to start", null, (Object)this.layout.sprites());
        try {
            this.layout.sprites(SPRITE);
            Assert.fail((String)AM_NOEX);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)AM_WREXMSG, (Object)"Cannot set sprites if geomap is set", (Object)e.getMessage());
        }
    }

    @Test
    public void setScale() {
        this.mkRootLayout();
        this.layout.scale(3.0);
        Assert.assertEquals((String)"wrong scale", (double)3.0, (double)this.layout.scale(), (double)9.9E-324);
        this.layout.scale(0.05);
        Assert.assertEquals((String)"wrong scale", (double)0.05, (double)this.layout.scale(), (double)9.9E-324);
    }

    @Test(expected=IllegalArgumentException.class)
    public void scaleTooSmall() {
        this.mkRootLayout();
        this.layout.scale(0.0099);
    }

    @Test(expected=IllegalArgumentException.class)
    public void scaleTooBig() {
        this.mkRootLayout();
        this.layout.scale(100.009);
    }

    @Test
    public void setXOff() {
        this.mkOtherLayout();
        this.layout.offsetX(23.4);
        Assert.assertEquals((String)"wrong x-offset", (double)23.4, (double)this.layout.offsetX(), (double)9.9E-324);
    }

    @Test
    public void setYOff() {
        this.mkOtherLayout();
        this.layout.offsetY(2.71828);
        Assert.assertEquals((String)"wrong y-offset", (double)2.71828, (double)this.layout.offsetY(), (double)9.9E-324);
    }
}

