/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;

public class PartitionDiff {
    private final Partition oldValue;
    private final Partition newValue;
    private final PartitionId partitionId;
    private final Set<NodeId> currentMembers;
    private final Set<NodeId> newMembers;

    public PartitionDiff(Partition oldValue, Partition newValue) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.partitionId = oldValue.getId();
        this.currentMembers = oldValue == null ? ImmutableSet.of() : ImmutableSet.copyOf(oldValue.getMembers());
        this.newMembers = newValue == null ? ImmutableSet.of() : ImmutableSet.copyOf(newValue.getMembers());
    }

    public PartitionId partitionId() {
        return this.partitionId;
    }

    public Partition oldValue() {
        return this.oldValue;
    }

    public Partition newValue() {
        return this.newValue;
    }

    public boolean hasChanged() {
        return !Sets.symmetricDifference(this.currentMembers, this.newMembers).isEmpty();
    }

    public boolean isAdded(NodeId nodeId) {
        return !this.currentMembers.contains(nodeId) && this.newMembers.contains(nodeId);
    }

    public boolean isRemoved(NodeId nodeId) {
        return this.currentMembers.contains(nodeId) && !this.newMembers.contains(nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.oldValue, this.newValue);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof PartitionDiff)) {
            return false;
        }
        PartitionDiff that = (PartitionDiff)other;
        return Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("oldValue", (Object)this.oldValue).add("newValue", (Object)this.newValue).toString();
    }
}

