/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.net.AbstractModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MutableAnnotations;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.driver.Projectable;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractProjectableModel
extends AbstractModel
implements Projectable {
    private static Logger log = LoggerFactory.getLogger(AbstractProjectableModel.class);
    protected static final String NO_DRIVER_SERVICE = "Driver service not bound yet";
    protected static final String NO_DRIVER = "Driver has not been bound to %s";
    private static DriverService driverService;
    private Driver driver;

    public AbstractProjectableModel() {
    }

    public AbstractProjectableModel(ProviderId providerId, Annotations[] annotations) {
        super(providerId, annotations);
    }

    public static void setDriverService(Object key, DriverService driverService) {
        AbstractProjectableModel.driverService = driverService;
    }

    protected static DriverService driverService() {
        return driverService;
    }

    public Driver driver() {
        return this.driver;
    }

    @Override
    public <B extends Behaviour> B as(Class<B> projectionClass) {
        this.bindAndCheckDriver();
        return this.driver.createBehaviour(this.asData(), projectionClass);
    }

    @Override
    public <B extends Behaviour> boolean is(Class<B> projectionClass) {
        this.bindDriver();
        return this.driver != null && this.driver.hasBehaviour(projectionClass);
    }

    protected Driver locateDriver() {
        String driverName;
        Annotations annotations = this.annotations();
        String string = driverName = annotations != null ? annotations.value("driver") : null;
        if (driverName != null) {
            try {
                return driverService.getDriver(driverName);
            }
            catch (ItemNotFoundException e) {
                log.warn("Driver {} not found.", (Object)driverName);
            }
        }
        return null;
    }

    protected final void bindDriver() {
        Preconditions.checkState((driverService != null ? 1 : 0) != 0, (Object)NO_DRIVER_SERVICE);
        if (this.driver == null) {
            this.driver = this.locateDriver();
        }
    }

    protected final void bindAndCheckDriver() {
        this.bindDriver();
        Preconditions.checkState((this.driver != null ? 1 : 0) != 0, (String)NO_DRIVER, (Object[])new Object[]{this});
    }

    protected DriverData asData() {
        return new AnnotationDriverData();
    }

    protected class AnnotationDriverData
    implements DriverData {
        protected AnnotationDriverData() {
        }

        @Override
        public Driver driver() {
            return AbstractProjectableModel.this.driver;
        }

        @Override
        public DeviceId deviceId() {
            throw new UnsupportedOperationException("Entity not a device");
        }

        @Override
        public MutableAnnotations set(String key, String value) {
            throw new UnsupportedOperationException("Entity is immutable");
        }

        @Override
        public MutableAnnotations clear(String ... keys) {
            throw new UnsupportedOperationException("Entity is immutable");
        }

        @Override
        public Set<String> keys() {
            return AbstractProjectableModel.this.annotations().keys();
        }

        @Override
        public String value(String key) {
            return AbstractProjectableModel.this.annotations().value(key);
        }
    }
}

